/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.nativeclient;

import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.elasticsearch.AbstractElasticSearchDataContext;
import org.apache.metamodel.elasticsearch.common.ElasticSearchMetaData;
import org.apache.metamodel.elasticsearch.common.ElasticSearchMetaDataParser;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchDataSet;
import org.apache.metamodel.elasticsearch.nativeclient.ElasticSearchUpdateCallback;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequestBuilder;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ElasticSearchDataContext
extends AbstractElasticSearchDataContext {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchDataContext.class);
    private final Client elasticSearchClient;

    public ElasticSearchDataContext(Client client, String indexName, SimpleTableDef ... tableDefinitions) {
        super(indexName, tableDefinitions);
        if (client == null) {
            throw new IllegalArgumentException("ElasticSearch Client cannot be null");
        }
        this.elasticSearchClient = client;
        this.dynamicTableDefinitions.addAll(Arrays.asList(this.detectSchema()));
    }

    public ElasticSearchDataContext(Client client, String indexName) {
        this(client, indexName, new SimpleTableDef[0]);
    }

    protected SimpleTableDef[] detectSchema() {
        logger.info("Detecting schema for index '{}'", (Object)this.indexName);
        ClusterStateRequestBuilder clusterStateRequestBuilder = this.getElasticSearchClient().admin().cluster().prepareState().setIndices(new String[]{this.indexName});
        ClusterState cs = ((ClusterStateResponse)clusterStateRequestBuilder.execute().actionGet()).getState();
        ArrayList<SimpleTableDef> result = new ArrayList<SimpleTableDef>();
        IndexMetaData imd = cs.getMetaData().index(this.indexName);
        if (imd == null) {
            logger.warn("No metadata returned for index name '{}' - no tables will be detected.");
        } else {
            ImmutableOpenMap mappings = imd.getMappings();
            ObjectLookupContainer documentTypes = mappings.keys();
            for (ObjectCursor documentTypeCursor : documentTypes) {
                String documentType = documentTypeCursor.value.toString();
                try {
                    SimpleTableDef table = ElasticSearchDataContext.detectTable(cs, this.indexName, documentType);
                    result.add(table);
                }
                catch (Exception e) {
                    logger.error("Unexpected error during detectTable for document type '{}'", (Object)documentType, (Object)e);
                }
            }
        }
        return ElasticSearchDataContext.sortTables(result);
    }

    public static SimpleTableDef detectTable(ClusterState cs, String indexName, String documentType) throws Exception {
        logger.debug("Detecting table for document type '{}' in index '{}'", (Object)documentType, (Object)indexName);
        IndexMetaData imd = cs.getMetaData().index(indexName);
        if (imd == null) {
            throw new IllegalArgumentException("No such index: " + indexName);
        }
        ImmutableOpenMap mappings = imd.getMappings();
        MappingMetaData mappingMetaData = (MappingMetaData)mappings.get((Object)documentType);
        if (mappingMetaData == null) {
            throw new IllegalArgumentException("No such document type in index '" + indexName + "': " + documentType);
        }
        Map mp = mappingMetaData.getSourceAsMap();
        Object metadataProperties = mp.get("properties");
        if (metadataProperties != null && metadataProperties instanceof Map) {
            Map metadataPropertiesMap = (Map)metadataProperties;
            ElasticSearchMetaData metaData = ElasticSearchMetaDataParser.parse((Map)metadataPropertiesMap);
            SimpleTableDef std = new SimpleTableDef(documentType, metaData.getColumnNames(), metaData.getColumnTypes());
            return std;
        }
        throw new IllegalArgumentException("No mapping properties defined for document type '" + documentType + "' in index: " + indexName);
    }

    protected DataSet materializeMainSchemaTable(Table table, List<SelectItem> selectItems, List<FilterItem> whereItems, int firstRow, int maxRows) {
        QueryBuilder queryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere(whereItems, (LogicalOperator)LogicalOperator.AND);
        if (queryBuilder != null) {
            SearchRequestBuilder searchRequest = this.createSearchRequest(table, firstRow, maxRows, queryBuilder);
            SearchResponse response = (SearchResponse)searchRequest.execute().actionGet();
            return new ElasticSearchDataSet(this.getElasticSearchClient(), response, selectItems);
        }
        return super.materializeMainSchemaTable(table, selectItems, whereItems, firstRow, maxRows);
    }

    protected DataSet materializeMainSchemaTable(Table table, List<Column> columns, int maxRows) {
        SearchRequestBuilder searchRequest = this.createSearchRequest(table, 1, maxRows, null);
        SearchResponse response = (SearchResponse)searchRequest.execute().actionGet();
        return new ElasticSearchDataSet(this.getElasticSearchClient(), response, columns.stream().map(SelectItem::new).collect(Collectors.toList()));
    }

    private SearchRequestBuilder createSearchRequest(Table table, int firstRow, int maxRows, QueryBuilder queryBuilder) {
        String documentType = table.getName();
        SearchRequestBuilder searchRequest = this.getElasticSearchClient().prepareSearch(new String[]{this.indexName}).setTypes(new String[]{documentType});
        if (firstRow > 1) {
            int zeroBasedFrom = firstRow - 1;
            searchRequest.setFrom(zeroBasedFrom);
        }
        if (this.limitMaxRowsIsSet(maxRows)) {
            searchRequest.setSize(maxRows);
        } else {
            searchRequest.setScroll(TIMEOUT_SCROLL);
        }
        if (queryBuilder != null) {
            searchRequest.setQuery(queryBuilder);
        }
        return searchRequest;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        if (keyValue == null) {
            return null;
        }
        String documentType = table.getName();
        String id = keyValue.toString();
        GetResponse response = (GetResponse)this.getElasticSearchClient().prepareGet(this.indexName, documentType, id).execute().actionGet();
        if (!response.isExists()) {
            return null;
        }
        Map source = response.getSource();
        String documentId = response.getId();
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        return ElasticSearchUtils.createRow((Map)source, (String)documentId, (DataSetHeader)header);
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (!whereItems.isEmpty()) {
            return null;
        }
        String documentType = table.getName();
        TermQueryBuilder query = QueryBuilders.termQuery((String)"_type", (String)documentType);
        SearchResponse searchResponse = (SearchResponse)this.getElasticSearchClient().prepareSearch(new String[]{this.indexName}).setSource(new SearchSourceBuilder().size(0).query((QueryBuilder)query)).execute().actionGet();
        return searchResponse.getHits().getTotalHits().value;
    }

    public UpdateSummary executeUpdate(UpdateScript update) {
        ElasticSearchUpdateCallback callback = new ElasticSearchUpdateCallback(this);
        update.run((UpdateCallback)callback);
        callback.onExecuteUpdateFinished();
        return callback.getUpdateSummary();
    }

    protected void onSchemaCacheRefreshed() {
        this.getElasticSearchClient().admin().indices().prepareRefresh(new String[]{this.indexName}).get();
        this.detectSchema();
    }

    public Client getElasticSearchClient() {
        return this.elasticSearchClient;
    }
}

