/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.dynamodb.DynamoDbUtils;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;

final class DynamoDbDataSet
extends AbstractDataSet {
    private final Iterator<Map<String, AttributeValue>> _iterator;
    private Map<String, AttributeValue> _currentItem;

    public DynamoDbDataSet(List<Column> columns, ScanResult result) {
        super(columns.stream().map(SelectItem::new).collect(Collectors.toList()));
        this._iterator = result.getItems().iterator();
    }

    public boolean next() {
        boolean hasNext = this._iterator.hasNext();
        if (hasNext) {
            this._currentItem = this._iterator.next();
            return true;
        }
        this._currentItem = null;
        return false;
    }

    public Row getRow() {
        if (this._currentItem == null) {
            return null;
        }
        DataSetHeader header = this.getHeader();
        Object[] values = new Object[header.size()];
        for (int i = 0; i < values.length; ++i) {
            AttributeValue attributeValue = this._currentItem.get(header.getSelectItem(i).getColumn().getName());
            values[i] = DynamoDbUtils.toValue(attributeValue);
        }
        DefaultRow row = new DefaultRow(header, values);
        return row;
    }
}

