/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import java.util.ArrayList;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.dynamodb.DynamoDbUpdateCallback;
import org.apache.metamodel.dynamodb.DynamoDbUtils;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamoDbTableCreationBuilder
extends AbstractTableCreationBuilder<DynamoDbUpdateCallback> {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDbTableCreationBuilder.class);

    public DynamoDbTableCreationBuilder(DynamoDbUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
    }

    public Table execute() throws MetaModelException {
        MutableTable table = this.getTable();
        String tableName = table.getName();
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        ArrayList globalSecondaryIndices = new ArrayList();
        long readCapacity = Long.parseLong(System.getProperty("metamodel.dynamodb.throughput.capacity.read", "5"));
        long writeCapacity = Long.parseLong(System.getProperty("metamodel.dynamodb.throughput.capacity.write", "5"));
        ProvisionedThroughput provisionedThroughput = new ProvisionedThroughput(Long.valueOf(readCapacity), Long.valueOf(writeCapacity));
        for (Column column : table.getColumns()) {
            if (!column.isPrimaryKey()) continue;
            KeyType keyType = this.getKeyType(column.getRemarks());
            keySchema.add(new KeySchemaElement(column.getName(), keyType));
            attributes.add(new AttributeDefinition(column.getName(), DynamoDbUtils.toAttributeType(column.getType())));
        }
        CreateTableRequest createTableRequest = new CreateTableRequest();
        createTableRequest.setTableName(tableName);
        createTableRequest.setAttributeDefinitions(attributes);
        createTableRequest.setGlobalSecondaryIndexes(globalSecondaryIndices);
        createTableRequest.setKeySchema(keySchema);
        createTableRequest.setProvisionedThroughput(provisionedThroughput);
        AmazonDynamoDB client = ((DynamoDbUpdateCallback)this.getUpdateCallback()).getDataContext().getDynamoDb();
        CreateTableResult createTableResult = client.createTable(createTableRequest);
        String tableStatus = createTableResult.getTableDescription().getTableStatus();
        while (TableStatus.CREATING.name().equals(tableStatus)) {
            logger.debug("Waiting for table status to be ACTIVE. Currently: {}", (Object)tableStatus);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                ((DynamoDbUpdateCallback)this.getUpdateCallback()).setInterrupted(true);
            }
            tableStatus = client.describeTable(tableName).getTable().getTableStatus();
        }
        return table;
    }

    private KeyType getKeyType(String remarks) {
        if ("RANGE".equals(remarks)) {
            return KeyType.RANGE;
        }
        return KeyType.HASH;
    }
}

