/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.dynamodb;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.dynamodb.DynamoDbDataContext;
import org.apache.metamodel.factory.AbstractDataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.util.SimpleTableDef;

public class DynamoDbDataContextFactory
extends AbstractDataContextFactory {
    protected String getType() {
        return "dynamodb";
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        AmazonDynamoDBClientBuilder clientBuilder = (AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withCredentials(this.getCredentials(properties));
        Object region = properties.toMap().get("region");
        if (region instanceof String) {
            clientBuilder.setRegion((String)region);
        }
        AmazonDynamoDB client = (AmazonDynamoDB)clientBuilder.build();
        SimpleTableDef[] tableDefs = properties.getTableDefs();
        return new DynamoDbDataContext(client, tableDefs);
    }

    private AWSCredentialsProvider getCredentials(DataContextProperties properties) {
        if (properties.getUsername() != null) {
            BasicAWSCredentials credentials = new BasicAWSCredentials(properties.getUsername(), properties.getPassword());
            return new AWSStaticCredentialsProvider((AWSCredentials)credentials);
        }
        return DefaultAWSCredentialsProviderChain.getInstance();
    }
}

