/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import org.apache.metamodel.DataContext;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvDataContext;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.util.Resource;

public class CsvDataContextFactory
implements DataContextFactory {
    public static final String PROPERTY_TYPE = "csv";

    public boolean accepts(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        return PROPERTY_TYPE.equals(properties.getDataContextType());
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        assert (this.accepts(properties, resourceFactoryRegistry));
        Resource resource = resourceFactoryRegistry.createResource(properties.getResourceProperties());
        int columnNameLineNumber = this.getInt(properties.getColumnNameLineNumber(), 1);
        String encoding = this.getString(properties.getEncoding(), "UTF-8");
        char separatorChar = this.getChar(properties.getSeparatorChar(), ',');
        char quoteChar = this.getChar(properties.getQuoteChar(), '\"');
        char escapeChar = this.getChar(properties.getEscapeChar(), '\\');
        boolean failOnInconsistentRowLength = this.getBoolean(properties.isFailOnInconsistentRowLength(), false);
        boolean multilineValuesEnabled = this.getBoolean(properties.isMultilineValuesEnabled(), true);
        CsvConfiguration configuration = new CsvConfiguration(columnNameLineNumber, encoding, separatorChar, quoteChar, escapeChar, failOnInconsistentRowLength, multilineValuesEnabled);
        return new CsvDataContext(resource, configuration);
    }

    private String getString(String value, String ifNull) {
        return value == null ? ifNull : value;
    }

    private int getInt(Integer value, int ifNull) {
        return value == null ? ifNull : value;
    }

    private boolean getBoolean(Boolean value, boolean ifNull) {
        return value == null ? ifNull : value;
    }

    private char getChar(Character value, char ifNull) {
        return value == null ? ifNull : value.charValue();
    }
}

