/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import org.apache.metamodel.csv.CsvConfiguration;

public final class CsvWriter {
    public static final int INITIAL_STRING_SIZE = 128;
    private final CsvConfiguration _configuration;

    public CsvWriter(CsvConfiguration configuration) {
        this._configuration = configuration;
    }

    public String buildLine(String[] nextLine) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < nextLine.length; ++i) {
            String nextElement;
            if (i != 0) {
                sb.append(this._configuration.getSeparatorChar());
            }
            if ((nextElement = nextLine[i]) == null) continue;
            char quoteChar = this._configuration.getQuoteChar();
            if (quoteChar != '\uffff') {
                sb.append(quoteChar);
            }
            sb.append(this.valueNeedsEscaping(nextElement) ? this.processValue(nextElement) : nextElement);
            if (quoteChar == '\uffff') continue;
            sb.append(quoteChar);
        }
        sb.append('\n');
        return sb.toString();
    }

    private boolean valueNeedsEscaping(String line) {
        boolean result;
        boolean bl = result = line.indexOf(this._configuration.getQuoteChar()) != -1 || line.indexOf(this._configuration.getEscapeChar()) != -1;
        if (!result) {
            result = this._configuration.getQuoteChar() == '\uffff' && line.indexOf(this._configuration.getSeparatorChar()) != -1;
        }
        return result;
    }

    private String processValue(String value) {
        char escapeChar = this._configuration.getEscapeChar();
        if (escapeChar == '\uffff') {
            return value;
        }
        char quoteChar = this._configuration.getQuoteChar();
        char separatorChar = this._configuration.getSeparatorChar();
        StringBuilder sb = new StringBuilder(value.length() + 10);
        for (int j = 0; j < value.length(); ++j) {
            char nextChar = value.charAt(j);
            if (nextChar == quoteChar) {
                sb.append(escapeChar).append(nextChar);
                continue;
            }
            if (nextChar == escapeChar) {
                sb.append(escapeChar).append(nextChar);
                continue;
            }
            if (quoteChar == '\uffff' && nextChar == separatorChar) {
                sb.append(escapeChar).append(nextChar);
                continue;
            }
            sb.append(nextChar);
        }
        return sb.toString();
    }
}

