/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import java.io.Serializable;
import java.util.List;
import org.apache.metamodel.util.BaseObject;

public final class CsvConfiguration
extends BaseObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final char NOT_A_CHAR = '\uffff';
    public static final int NO_COLUMN_NAME_LINE = 0;
    public static final int DEFAULT_COLUMN_NAME_LINE = 1;
    public static final char DEFAULT_SEPARATOR_CHAR = ',';
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    public static final char DEFAULT_ESCAPE_CHAR = '\\';
    private final int columnNameLineNumber;
    private final String encoding;
    private final char separatorChar;
    private final char quoteChar;
    private final char escapeChar;
    private final boolean failOnInconsistentRowLength;
    private final boolean multilineValues;

    public CsvConfiguration() {
        this(1);
    }

    public CsvConfiguration(int columnNameLineNumber) {
        this(columnNameLineNumber, "UTF-8", ',', '\"', '\\');
    }

    public CsvConfiguration(int columnNameLineNumber, boolean failOnInconsistentRowLength, boolean multilineValues) {
        this(columnNameLineNumber, "UTF-8", ',', '\"', '\\', failOnInconsistentRowLength, multilineValues);
    }

    public CsvConfiguration(int columnNameLineNumber, String encoding, char separatorChar, char quoteChar, char escapeChar) {
        this(columnNameLineNumber, encoding, separatorChar, quoteChar, escapeChar, false);
    }

    public CsvConfiguration(int columnNameLineNumber, String encoding, char separatorChar, char quoteChar, char escapeChar, boolean failOnInconsistentRowLength) {
        this(columnNameLineNumber, encoding, separatorChar, quoteChar, escapeChar, failOnInconsistentRowLength, true);
    }

    public CsvConfiguration(int columnNameLineNumber, String encoding, char separatorChar, char quoteChar, char escapeChar, boolean failOnInconsistentRowLength, boolean multilineValues) {
        this.columnNameLineNumber = columnNameLineNumber;
        this.encoding = encoding;
        this.separatorChar = separatorChar;
        this.quoteChar = quoteChar;
        this.escapeChar = escapeChar;
        this.failOnInconsistentRowLength = failOnInconsistentRowLength;
        this.multilineValues = multilineValues;
    }

    public boolean isFailOnInconsistentRowLength() {
        return this.failOnInconsistentRowLength;
    }

    public boolean isMultilineValues() {
        return this.multilineValues;
    }

    public int getColumnNameLineNumber() {
        return this.columnNameLineNumber;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }

    public char getQuoteChar() {
        return this.quoteChar;
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this.columnNameLineNumber);
        identifiers.add(this.encoding);
        identifiers.add(Character.valueOf(this.separatorChar));
        identifiers.add(Character.valueOf(this.quoteChar));
        identifiers.add(Character.valueOf(this.escapeChar));
        identifiers.add(this.failOnInconsistentRowLength);
    }

    public String toString() {
        return "CsvConfiguration[columnNameLineNumber=" + this.columnNameLineNumber + ", encoding=" + this.encoding + ", separatorChar=" + this.separatorChar + ", quoteChar=" + this.quoteChar + ", escapeChar=" + this.escapeChar + ", failOnInconsistentRowLength=" + this.failOnInconsistentRowLength + "]";
    }
}

