/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import au.com.bytecode.opencsv.CSVParser;
import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.csv.CsvConfiguration;
import org.apache.metamodel.csv.CsvDataSet;
import org.apache.metamodel.csv.CsvSchema;
import org.apache.metamodel.csv.CsvTable;
import org.apache.metamodel.csv.CsvUpdateCallback;
import org.apache.metamodel.csv.SingleLineCsvDataSet;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.EmptyDataSet;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.FileHelper;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.ResourceUtils;
import org.apache.metamodel.util.UrlResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CsvDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(CsvDataContext.class);
    private final Object WRITE_LOCK = new Object();
    private final Resource _resource;
    private final CsvConfiguration _configuration;
    private final boolean _writable;

    public CsvDataContext(File file, CsvConfiguration configuration) {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("CsvConfiguration cannot be null");
        }
        this._resource = new FileResource(file);
        this._configuration = configuration;
        this._writable = true;
    }

    public CsvDataContext(Resource resource, CsvConfiguration configuration) {
        if (resource == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (configuration == null) {
            throw new IllegalArgumentException("CsvConfiguration cannot be null");
        }
        this._resource = resource;
        this._configuration = configuration;
        this._writable = !resource.isReadOnly();
    }

    public CsvDataContext(URL url, CsvConfiguration configuration) {
        this._resource = new UrlResource(url);
        this._configuration = configuration;
        this._writable = false;
    }

    public CsvDataContext(File file) {
        this(file, new CsvConfiguration());
    }

    public CsvDataContext(InputStream inputStream, CsvConfiguration configuration) {
        File file = CsvDataContext.createFileFromInputStream(inputStream, configuration.getEncoding());
        this._configuration = configuration;
        this._writable = false;
        this._resource = new FileResource(file);
    }

    @Deprecated
    public CsvDataContext(File file, char separatorChar) {
        this(file, separatorChar, '\"');
    }

    @Deprecated
    public CsvDataContext(File file, char separatorChar, char quoteChar) {
        this(file, new CsvConfiguration(1, "UTF-8", separatorChar, quoteChar, '\\'));
    }

    @Deprecated
    public CsvDataContext(File file, char separatorChar, char quoteChar, String encoding) {
        this(file, new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\'));
    }

    @Deprecated
    public CsvDataContext(URL url, char separatorChar, char quoteChar) {
        this(url, separatorChar, quoteChar, "UTF-8");
    }

    @Deprecated
    public CsvDataContext(URL url, char separatorChar, char quoteChar, String encoding) {
        this(url, new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\'));
    }

    @Deprecated
    public CsvDataContext(InputStream inputStream, char separatorChar, char quoteChar) {
        this(inputStream, new CsvConfiguration(1, "UTF-8", separatorChar, quoteChar, '\\'));
    }

    @Deprecated
    public CsvDataContext(InputStream inputStream, char separatorChar, char quoteChar, String encoding) {
        this(inputStream, new CsvConfiguration(1, encoding, separatorChar, quoteChar, '\\'));
    }

    public CsvConfiguration getConfiguration() {
        return this._configuration;
    }

    @Deprecated
    public File getFile() {
        if (this._resource instanceof FileResource) {
            return ((FileResource)this._resource).getFile();
        }
        return null;
    }

    public Resource getResource() {
        return this._resource;
    }

    private static File createFileFromInputStream(InputStream inputStream, String encoding) {
        File tempDir = FileHelper.getTempDir();
        File fileCandidate = null;
        boolean usableName = false;
        int index = 0;
        while (!usableName) {
            fileCandidate = new File(tempDir, "metamodel" + ++index + ".csv");
            usableName = !fileCandidate.exists();
        }
        File file = fileCandidate;
        BufferedWriter writer = FileHelper.getBufferedWriter(file, (String)encoding);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            file.createNewFile();
            file.deleteOnExit();
            boolean firstLine = true;
            String line = reader.readLine();
            while (line != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    writer.write(10);
                }
                writer.write(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                FileHelper.safeClose((Object[])new Object[]{writer, reader});
                throw throwable;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{writer, reader});
        return file;
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (!functionApproximationAllowed) {
            return null;
        }
        if (whereItems != null && !whereItems.isEmpty()) {
            return null;
        }
        final long length = this._resource.getSize();
        if (length < 0L) {
            return null;
        }
        return (Number)this._resource.read((Func)new Func<InputStream, Number>(){

            public Number eval(InputStream inputStream) {
                try {
                    int read;
                    int sampleSize = (int)Math.min(length, 0x500000L);
                    int chunkSize = Math.min(sampleSize, 0x100000);
                    int readSize = 0;
                    int newlines = 0;
                    int carriageReturns = 0;
                    byte[] byteBuffer = new byte[chunkSize];
                    char[] charBuffer = new char[chunkSize];
                    while (readSize < sampleSize && (read = inputStream.read(byteBuffer)) != -1) {
                        readSize += read;
                        Reader reader = CsvDataContext.this.getReader(byteBuffer, CsvDataContext.this._configuration.getEncoding());
                        reader.read(charBuffer);
                        for (char c : charBuffer) {
                            if ('\n' == c) {
                                ++newlines;
                                continue;
                            }
                            if ('\r' != c) continue;
                            ++carriageReturns;
                        }
                    }
                    int lines = Math.max(newlines, carriageReturns);
                    logger.info("Found {} lines breaks in {} bytes", (Object)lines, (Object)sampleSize);
                    long approxCount = (long)lines * length / (long)sampleSize;
                    return approxCount;
                }
                catch (IOException e) {
                    logger.error("Unexpected error during COUNT(*) approximation", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private Reader getReader(byte[] byteBuffer, String encoding) throws UnsupportedEncodingException {
        try {
            return new InputStreamReader((InputStream)new ByteArrayInputStream(byteBuffer), encoding);
        }
        catch (UnsupportedEncodingException e1) {
            try {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(byteBuffer), "UTF8");
            }
            catch (UnsupportedEncodingException e2) {
                throw e1;
            }
        }
    }

    public DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        Integer maxRowsOrNull;
        int lineNumber = this._configuration.getColumnNameLineNumber();
        int columnCount = table.getColumnCount();
        BufferedReader reader = FileHelper.getBufferedReader((InputStream)this._resource.read(), (String)this._configuration.getEncoding());
        try {
            for (int i = 0; i < lineNumber; ++i) {
                String line = reader.readLine();
                if (line != null) continue;
                return new EmptyDataSet(columns);
            }
        }
        catch (IOException e) {
            throw new MetaModelException("IOException occurred while reading from CSV resource: " + this._resource, (Exception)e);
        }
        boolean failOnInconsistentRowLength = this._configuration.isFailOnInconsistentRowLength();
        Integer n = maxRowsOrNull = maxRows > 0 ? Integer.valueOf(maxRows) : null;
        if (this._configuration.isMultilineValues()) {
            CSVReader csvReader = this.createCsvReader(reader);
            return new CsvDataSet(csvReader, columns, maxRowsOrNull, columnCount, failOnInconsistentRowLength);
        }
        CSVParser csvParser = new CSVParser(this._configuration.getSeparatorChar(), this._configuration.getQuoteChar(), this._configuration.getEscapeChar());
        return new SingleLineCsvDataSet(reader, csvParser, columns, maxRowsOrNull, columnCount, failOnInconsistentRowLength);
    }

    protected CSVReader createCsvReader(int skipLines) {
        Reader reader = FileHelper.getReader((InputStream)this._resource.read(), (String)this._configuration.getEncoding());
        CSVReader csvReader = new CSVReader(reader, this._configuration.getSeparatorChar(), this._configuration.getQuoteChar(), this._configuration.getEscapeChar(), skipLines);
        return csvReader;
    }

    protected CSVReader createCsvReader(BufferedReader reader) {
        CSVReader csvReader = new CSVReader((Reader)reader, this._configuration.getSeparatorChar(), this._configuration.getQuoteChar(), this._configuration.getEscapeChar());
        return csvReader;
    }

    protected CsvSchema getMainSchema() throws MetaModelException {
        CsvSchema schema = new CsvSchema(this.getMainSchemaName(), this);
        if (this._resource.isExists()) {
            schema.setTable(new CsvTable(schema, this._resource.getName()));
        }
        return schema;
    }

    protected String getMainSchemaName() {
        return ResourceUtils.getParentName((Resource)this._resource);
    }

    protected boolean isWritable() {
        return this._writable;
    }

    private void checkWritable() {
        if (!this.isWritable()) {
            throw new IllegalStateException("This CSV DataContext is not writable, as it based on a read-only resource.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(UpdateScript update) {
        this.checkWritable();
        CsvUpdateCallback callback = new CsvUpdateCallback(this);
        Object object = this.WRITE_LOCK;
        synchronized (object) {
            try {
                update.run((UpdateCallback)callback);
            }
            finally {
                callback.close();
            }
        }
    }
}

