/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import java.util.List;
import org.apache.metamodel.couchdb.CouchDbUtils;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.ektorp.StreamingViewResult;
import org.ektorp.ViewResult;

final class CouchDbDataSet
extends AbstractDataSet {
    private final Iterator<ViewResult.Row> _iterator;
    private final StreamingViewResult _streamingViewResult;
    private Row _row;

    public CouchDbDataSet(List<SelectItem> selectItems, StreamingViewResult streamingViewResult) {
        super(selectItems);
        this._streamingViewResult = streamingViewResult;
        this._iterator = this._streamingViewResult.iterator();
    }

    public boolean next() {
        if (this._iterator == null || !this._iterator.hasNext()) {
            return false;
        }
        ViewResult.Row row = this._iterator.next();
        JsonNode node = row.getDocAsNode();
        DataSetHeader header = this.getHeader();
        this._row = CouchDbUtils.jsonNodeToMetaModelRow(node, header);
        return true;
    }

    public Row getRow() {
        return this._row;
    }

    public void close() {
        super.close();
        this._streamingViewResult.close();
    }
}

