/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.couchdb;

import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.couchdb.CouchDbUpdateCallback;
import org.apache.metamodel.create.AbstractTableCreationBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.ektorp.CouchDbInstance;

final class CouchDbTableCreationBuilder
extends AbstractTableCreationBuilder<CouchDbUpdateCallback> {
    public CouchDbTableCreationBuilder(CouchDbUpdateCallback updateCallback, Schema schema, String name) {
        super((UpdateCallback)updateCallback, schema, name);
    }

    public Table execute() throws MetaModelException {
        MutableTable table = this.getTable();
        String name = table.getName();
        CouchDbInstance instance = ((CouchDbUpdateCallback)this.getUpdateCallback()).getDataContext().getCouchDbInstance();
        instance.createDatabase(name);
        CouchDbTableCreationBuilder.addMandatoryColumns(table);
        MutableSchema schema = (MutableSchema)table.getSchema();
        schema.addTable((Table)table);
        return table;
    }

    public static void addMandatoryColumns(MutableTable table) {
        MutableColumn idColumn = (MutableColumn)table.getColumnByName("_id");
        if (idColumn == null) {
            idColumn = new MutableColumn("_id", ColumnType.VARCHAR, (Table)table, 0, Boolean.valueOf(false));
            table.addColumn(0, (Column)idColumn);
        }
        idColumn.setPrimaryKey(true);
        idColumn.setNullable(Boolean.valueOf(false));
        MutableColumn revColumn = (MutableColumn)table.getColumnByName("_rev");
        if (revColumn == null) {
            revColumn = new MutableColumn("_rev", ColumnType.VARCHAR, (Table)table, 1, Boolean.valueOf(false));
            table.addColumn(1, (Column)revColumn);
        }
        revColumn.setNullable(Boolean.valueOf(false));
    }
}

