/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.cassandra;

import com.datastax.driver.core.Cluster;
import com.google.common.base.Strings;
import java.util.Map;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.cassandra.CassandraDataContext;
import org.apache.metamodel.factory.AbstractDataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;

public class CassandraDataContextFactory
extends AbstractDataContextFactory {
    protected String getType() {
        return "cassandra";
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        Map map = properties.toMap();
        Cluster.Builder clusterBuilder = Cluster.builder();
        String hostname = properties.getHostname();
        if (!Strings.isNullOrEmpty((String)hostname)) {
            clusterBuilder.addContactPoints(hostname.split(","));
        }
        if (properties.getPort() != null) {
            clusterBuilder.withPort(properties.getPort().intValue());
        }
        if (map.containsKey("cluster-name")) {
            clusterBuilder.withClusterName((String)map.get("cluster-name"));
        }
        if (properties.getUsername() != null && properties.getPassword() != null) {
            clusterBuilder.withCredentials(properties.getUsername(), properties.getPassword());
        }
        Cluster cluster = clusterBuilder.build();
        String keySpace = this.getString(map.get("keyspace"), properties.getDatabaseName());
        return new CassandraDataContext(cluster, keySpace, properties.getTableDefs());
    }
}

