/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.transport.http;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractor;
import org.eclipse.aether.spi.connector.transport.http.ChecksumExtractorStrategy;

@Singleton
@Named
public final class DefaultChecksumExtractor
implements ChecksumExtractor {
    private final Map<String, ChecksumExtractorStrategy> strategies;

    @Inject
    public DefaultChecksumExtractor(Map<String, ChecksumExtractorStrategy> strategies) {
        this.strategies = Objects.requireNonNull(strategies, "strategies");
    }

    public Map<String, String> extractChecksums(Function<String, String> headerGetter) {
        for (ChecksumExtractorStrategy strategy : this.strategies.values()) {
            Map extracted = strategy.extractChecksums(headerGetter);
            if (extracted == null || extracted.isEmpty()) continue;
            return extracted;
        }
        return null;
    }
}

