/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.MultiRuntimeException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.filter.RemoteRepositoryFilterSourceSupport;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="groupId")
public final class GroupIdRemoteRepositoryFilterSource
extends RemoteRepositoryFilterSourceSupport
implements ArtifactResolverPostProcessor {
    public static final String NAME = "groupId";
    private static final String CONFIG_PROPS_PREFIX = "aether.remoteRepositoryFilter.groupId.";
    public static final String CONFIG_PROP_ENABLED = "aether.remoteRepositoryFilter.groupId";
    public static final String CONFIG_PROP_BASEDIR = "aether.remoteRepositoryFilter.groupId.basedir";
    public static final String LOCAL_REPO_PREFIX_DIR = ".remoteRepositoryFilters";
    public static final String CONFIG_PROP_RECORD = "aether.remoteRepositoryFilter.groupId.record";
    static final String GROUP_ID_FILE_PREFIX = "groupId-";
    static final String GROUP_ID_FILE_SUFFIX = ".txt";
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupIdRemoteRepositoryFilterSource.class);
    private final RepositorySystemLifecycle repositorySystemLifecycle;
    private final ConcurrentHashMap<Path, Set<String>> rules;
    private final ConcurrentHashMap<Path, Boolean> changedRules;
    private final AtomicBoolean onShutdownHandlerRegistered;
    private static final TreeSet<String> NOT_PRESENT = new TreeSet();
    private static final RemoteRepositoryFilter.Result NOT_PRESENT_RESULT = new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "GroupId file not present");

    @Inject
    public GroupIdRemoteRepositoryFilterSource(RepositorySystemLifecycle repositorySystemLifecycle) {
        this.repositorySystemLifecycle = Objects.requireNonNull(repositorySystemLifecycle);
        this.rules = new ConcurrentHashMap();
        this.changedRules = new ConcurrentHashMap();
        this.onShutdownHandlerRegistered = new AtomicBoolean(false);
    }

    @Override
    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_ENABLED});
    }

    public RemoteRepositoryFilter getRemoteRepositoryFilter(RepositorySystemSession session) {
        if (this.isEnabled(session) && !this.isRecord(session)) {
            return new GroupIdFilter(session);
        }
        return null;
    }

    public void postProcess(RepositorySystemSession session, List<ArtifactResult> artifactResults) {
        if (this.isEnabled(session) && this.isRecord(session)) {
            if (this.onShutdownHandlerRegistered.compareAndSet(false, true)) {
                this.repositorySystemLifecycle.addOnSystemEndedHandler(this::saveRecordedLines);
            }
            for (ArtifactResult artifactResult : artifactResults) {
                Path filePath;
                boolean newGroupId;
                if (!artifactResult.isResolved() || !(artifactResult.getRepository() instanceof RemoteRepository) || !(newGroupId = this.rules.computeIfAbsent(filePath = this.filePath(this.getBasedir(session, LOCAL_REPO_PREFIX_DIR, CONFIG_PROP_BASEDIR, false), artifactResult.getRepository().getId()), f -> Collections.synchronizedSet(new TreeSet())).add(artifactResult.getArtifact().getGroupId()))) continue;
                this.changedRules.put(filePath, Boolean.TRUE);
            }
        }
    }

    private Path filePath(Path basedir, String remoteRepositoryId) {
        return basedir.resolve(GROUP_ID_FILE_PREFIX + remoteRepositoryId + GROUP_ID_FILE_SUFFIX);
    }

    private Set<String> cacheRules(RepositorySystemSession session, RemoteRepository remoteRepository) {
        Path filePath = this.filePath(this.getBasedir(session, LOCAL_REPO_PREFIX_DIR, CONFIG_PROP_BASEDIR, false), remoteRepository.getId());
        return this.rules.computeIfAbsent(filePath, r -> {
            Set<String> rules = this.loadRepositoryRules(filePath);
            if (rules != NOT_PRESENT) {
                LOGGER.info("Loaded {} groupId for remote repository {}", (Object)rules.size(), (Object)remoteRepository.getId());
            }
            return rules;
        });
    }

    private Set<String> loadRepositoryRules(Path filePath) {
        if (Files.isReadable(filePath)) {
            Set<String> set;
            block10: {
                BufferedReader reader = Files.newBufferedReader(filePath, StandardCharsets.UTF_8);
                try {
                    String groupId;
                    TreeSet<String> result = new TreeSet<String>();
                    while ((groupId = reader.readLine()) != null) {
                        if (groupId.startsWith("#") || groupId.trim().isEmpty()) continue;
                        result.add(groupId);
                    }
                    set = Collections.unmodifiableSet(result);
                    if (reader == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                reader.close();
            }
            return set;
        }
        return NOT_PRESENT;
    }

    private boolean isRecord(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_RECORD});
    }

    private void saveRecordedLines() {
        if (this.changedRules.isEmpty()) {
            return;
        }
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Map.Entry<Path, Set<String>> entry : this.rules.entrySet()) {
            Set<String> recordedLines;
            Path filePath = entry.getKey();
            if (this.changedRules.get(filePath) != Boolean.TRUE || (recordedLines = entry.getValue()).isEmpty()) continue;
            try {
                TreeSet<String> result = new TreeSet<String>();
                result.addAll(this.loadRepositoryRules(filePath));
                result.addAll(recordedLines);
                LOGGER.info("Saving {} groupIds to '{}'", (Object)result.size(), (Object)filePath);
                FileUtils.writeFileWithBackup((Path)filePath, p -> Files.write(p, (Iterable<? extends CharSequence>)result, new OpenOption[0]));
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        MultiRuntimeException.mayThrow((String)"session save groupIds failure", exceptions);
    }

    private class GroupIdFilter
    implements RemoteRepositoryFilter {
        private final RepositorySystemSession session;

        private GroupIdFilter(RepositorySystemSession session) {
            this.session = session;
        }

        public RemoteRepositoryFilter.Result acceptArtifact(RemoteRepository remoteRepository, Artifact artifact) {
            return this.acceptGroupId(remoteRepository, artifact.getGroupId());
        }

        public RemoteRepositoryFilter.Result acceptMetadata(RemoteRepository remoteRepository, Metadata metadata) {
            return this.acceptGroupId(remoteRepository, metadata.getGroupId());
        }

        private RemoteRepositoryFilter.Result acceptGroupId(RemoteRepository remoteRepository, String groupId) {
            Set groupIds = GroupIdRemoteRepositoryFilterSource.this.cacheRules(this.session, remoteRepository);
            if (NOT_PRESENT == groupIds) {
                return NOT_PRESENT_RESULT;
            }
            if (groupIds.contains(groupId)) {
                return new RemoteRepositoryFilterSourceSupport.SimpleResult(true, "G:" + groupId + " allowed from " + remoteRepository);
            }
            return new RemoteRepositoryFilterSourceSupport.SimpleResult(false, "G:" + groupId + " NOT allowed from " + remoteRepository);
        }
    }
}

