package org.apache.maven.plugin.idea;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-idea-plugin. Call <pre>  mvn idea:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Sun Aug 03 23:17:52 CEST 2008
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-idea-plugin:2.2", 0 );
        append( sb, "", 0 );

        append( sb, "Maven IDEA Plugin 2.2", 0 );
        append( sb, "Maven Plugins", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 6 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "clean".equals( goal ) )
        {
            append( sb, "idea:clean", 0 );
            append( sb, "Removes all existing IDEA files for the project.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "idea:help", 0 );
            append( sb, "Display help information on maven-idea-plugin. Call\n\u00a0\u00a0mvn\u00a0idea:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "idea".equals( goal ) )
        {
            append( sb, "idea:idea", 0 );
            append( sb, "Goal for generating IDEA files from a POM. This plug-in provides the ability to generate project files (.ipr, .iml and .iws files) for IDEA.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dependenciesAsLibraries (Default: false)", 2 );
                append( sb, "Causes the module libraries to use a short name for all dependencies. This is very convenient but has been reported to cause problems with IDEA.", 3 );
                append( sb, "", 0 );

                append( sb, "deploymentDescriptorFile", 2 );
                append( sb, "Specify the location of the deployment descriptor file, if one is provided.", 3 );
                append( sb, "", 0 );

                append( sb, "downloadJavadocs (Default: false)", 2 );
                append( sb, "Enables/disables the downloading of javadoc attachments.", 3 );
                append( sb, "", 0 );

                append( sb, "downloadSources (Default: false)", 2 );
                append( sb, "Enables/disables the downloading of source attachments.", 3 );
                append( sb, "", 0 );

                append( sb, "exclude", 2 );
                append( sb, "A comma-separated list of directories that should be excluded. These directories are in addition to those already excluded, such as target/classes. A common use of this is to exclude the entire target directory.", 3 );
                append( sb, "", 0 );

                append( sb, "ideaPlugin (Default: false)", 2 );
                append( sb, "Tell IntelliJ IDEA that this module is an IntelliJ IDEA Plugin.", 3 );
                append( sb, "", 0 );

                append( sb, "ideaVersion (Default: 5.x)", 2 );
                append( sb, "Specify the version of IDEA to target. This is needed to identify the default formatting of project-jdk-name used by IDEA. Currently supports 4.x and 5.x.\n>This will only be used when parameter jdkName is not set.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocClassifier (Default: javadoc)", 2 );
                append( sb, "Sets the classifier string attached to an artifact javadoc archive name.", 3 );
                append( sb, "", 0 );

                append( sb, "jdkLevel", 2 );
                append( sb, "Specify the version of the JDK to use for the project for the purpose of enabled assertions and Java 5.0 language features. The default value is the specification version of the executing JVM.", 3 );
                append( sb, "", 0 );

                append( sb, "jdkName", 2 );
                append( sb, "Specify the name of the registered IDEA JDK to use for the project.", 3 );
                append( sb, "", 0 );

                append( sb, "libraries", 2 );
                append( sb, "An optional set of Library objects that allow you to specify a comma separated list of source dirs, class dirs, or to indicate that the library should be excluded from the module. For example:\n>\n\n<libraries>\n<library>\n<name>webwork</name>\n<sources>file://$webwork$/src/java</sources>\n<!--\n<classes>...</classes>\n<exclude>true</exclude>\n-->\n</library>\n</libraries>\n", 3 );
                append( sb, "", 0 );

                append( sb, "linkModules (Default: true)", 2 );
                append( sb, "Whether to link the reactor projects as dependency modules or as libraries.", 3 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Whether to update the existing project files or overwrite them.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceClassifier (Default: sources)", 2 );
                append( sb, "Sets the classifier string attached to an artifact source archive name.", 3 );
                append( sb, "", 0 );

                append( sb, "useFullNames (Default: false)", 2 );
                append( sb, "Whether to use full artifact names when referencing libraries.", 3 );
                append( sb, "", 0 );

                append( sb, "wildcardResourcePatterns (Default: !?*.java)", 2 );
                append( sb, "Specify the resource pattern in wildcard format, for example \'?*.xml;?*.properties\'. Currently supports 4.x and 5.x. Because IDEA doesn\'t distinguish between source and resources directories, this is needed. The default value corresponds to any file without a java extension. Please note that the default value includes package.html files as it\'s not possible to exclude those.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "module".equals( goal ) )
        {
            append( sb, "idea:module", 0 );
            append( sb, "Creates the module files (*.iml) for IntelliJ IDEA.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "dependenciesAsLibraries (Default: false)", 2 );
                append( sb, "Causes the module libraries to use a short name for all dependencies. This is very convenient but has been reported to cause problems with IDEA.", 3 );
                append( sb, "", 0 );

                append( sb, "deploymentDescriptorFile", 2 );
                append( sb, "Specify the location of the deployment descriptor file, if one is provided.", 3 );
                append( sb, "", 0 );

                append( sb, "downloadJavadocs (Default: false)", 2 );
                append( sb, "Enables/disables the downloading of javadoc attachments.", 3 );
                append( sb, "", 0 );

                append( sb, "downloadSources (Default: false)", 2 );
                append( sb, "Enables/disables the downloading of source attachments.", 3 );
                append( sb, "", 0 );

                append( sb, "exclude", 2 );
                append( sb, "A comma-separated list of directories that should be excluded. These directories are in addition to those already excluded, such as target.", 3 );
                append( sb, "", 0 );

                append( sb, "ideaPlugin (Default: false)", 2 );
                append( sb, "Tell IntelliJ IDEA that this module is an IntelliJ IDEA Plugin.", 3 );
                append( sb, "", 0 );

                append( sb, "ideaVersion (Default: 5.x)", 2 );
                append( sb, "Specify the version of IDEA to target. This is needed to identify the default formatting of project-jdk-name used by IDEA. Currently supports 4.x and 5.x.\n>This will only be used when parameter jdkName is not set.\n", 3 );
                append( sb, "", 0 );

                append( sb, "javadocClassifier (Default: javadoc)", 2 );
                append( sb, "Sets the classifier string attached to an artifact javadoc archive name.", 3 );
                append( sb, "", 0 );

                append( sb, "libraries", 2 );
                append( sb, "An optional set of Library objects that allow you to specify a comma separated list of source dirs, class dirs, or to indicate that the library should be excluded from the module. For example:\n>\n\n<libraries>\n<library>\n<name>webwork</name>\n<sources>file://$webwork$/src/java</sources>\n<!--\n<classes>...</classes>\n<exclude>true</exclude>\n-->\n</library>\n</libraries>\n", 3 );
                append( sb, "", 0 );

                append( sb, "linkModules (Default: true)", 2 );
                append( sb, "Whether to link the reactor projects as dependency modules or as libraries.", 3 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Whether to update the existing project files or overwrite them.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceClassifier (Default: sources)", 2 );
                append( sb, "Sets the classifier string attached to an artifact source archive name.", 3 );
                append( sb, "", 0 );

                append( sb, "useFullNames (Default: false)", 2 );
                append( sb, "Whether to use full artifact names when referencing libraries.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "project".equals( goal ) )
        {
            append( sb, "idea:project", 0 );
            append( sb, "Creates the project file (*.ipr) for IntelliJ IDEA.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "ideaVersion (Default: 5.x)", 2 );
                append( sb, "Specify the version of IDEA to target. This is needed to identify the default formatting of project-jdk-name used by IDEA. Currently supports 4.x and 5.x.\n>This will only be used when parameter jdkName is not set.\n", 3 );
                append( sb, "", 0 );

                append( sb, "jdkLevel", 2 );
                append( sb, "Specify the version of the JDK to use for the project for the purpose of enabled assertions and Java 5.0 language features. The default value is the specification version of the executing JVM.", 3 );
                append( sb, "", 0 );

                append( sb, "jdkName", 2 );
                append( sb, "Specify the name of the registered IDEA JDK to use for the project.", 3 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Whether to update the existing project files or overwrite them.", 3 );
                append( sb, "", 0 );

                append( sb, "wildcardResourcePatterns (Default: !?*.java)", 2 );
                append( sb, "Specify the resource pattern in wildcard format, for example \'?*.xml;?*.properties\'. Currently supports 4.x and 5.x. Because IDEA doesn\'t distinguish between source and resources directories, this is needed. The default value corresponds to any file without a java extension. Please note that the default value includes package.html files as it\'s not possible to exclude those.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "workspace".equals( goal ) )
        {
            append( sb, "idea:workspace", 0 );
            append( sb, "Creates the workspace file (*.iws) for IntelliJ IDEA.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "overwrite (Default: false)", 2 );
                append( sb, "Whether to update the existing project files or overwrite them.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     */
    private List toLines( String text, int indent )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i] );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     */
    private void toLines( List lines, String line )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
