package org.apache.maven.plugin.idea;

/*
 * Copyright 2005-2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.dom4j.io.XMLWriter;
import org.dom4j.io.OutputFormat;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

/**
 * Custom implementation of <a href="http://dom4j.org/apidocs/org/dom4j/io/XMLWriter.html">XMLWriter</a> for use with
 * the Idea plugin.
 */
public class IdeaXmlWriter
    extends XMLWriter
{
    /**
     * Default constructor.
     *
     * @param file output file to be written
     */
    public IdeaXmlWriter( File file )
        throws IOException
    {
        super( new FileWriter( file ), OutputFormat.createPrettyPrint() );
    }

    protected String escapeAttributeEntities( String text )
    {
        String answer = super.escapeAttributeEntities( text );
        answer = answer.replaceAll( "\n", "&#10;" );
        answer = answer.replaceAll( "\n\r", "&#10;" );
        return answer;
    }
}