/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.idea;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class IdeaMojo
extends AbstractMojo {
    private MavenProject project;
    private MavenProject executedProject;
    private String jdkName;

    public void execute() throws MojoExecutionException {
        if (this.executedProject == null) {
            this.executedProject = this.project;
        }
        this.rewriteModule();
        this.rewriteProject();
        this.rewriteWorkspace();
    }

    private void rewriteWorkspace() throws MojoExecutionException {
        File workspaceFile = new File(this.project.getBasedir(), this.project.getArtifactId() + ".iws");
        if (!workspaceFile.exists()) {
            FileWriter w = null;
            try {
                w = new FileWriter(workspaceFile);
                IOUtil.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/templates/default/workspace.xml"), (Writer)w);
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Unable to create workspace file", (Exception)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(w);
                    throw throwable;
                }
            }
            IOUtil.close((Writer)w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteProject() throws MojoExecutionException {
        File projectFile = new File(this.project.getBasedir(), this.project.getArtifactId() + ".ipr");
        try {
            Xpp3Dom module;
            InputStreamReader reader = projectFile.exists() ? new FileReader(projectFile) : new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/default/project.xml"));
            try {
                module = Xpp3DomBuilder.build((Reader)reader);
            }
            finally {
                IOUtil.close((Reader)reader);
            }
            if (this.jdkName != null) {
                this.setJdkName(module, this.jdkName);
            } else {
                String javaVersion = System.getProperty("java.version");
                String defaultJdkName = "java version " + javaVersion;
                this.getLog().info((CharSequence)("jdkName is not set, using[" + defaultJdkName + "] as default."));
                this.setJdkName(module, defaultJdkName);
            }
            Xpp3Dom component = this.findComponent(module, "ProjectModuleManager");
            Xpp3Dom modules = this.findElement(component, "modules");
            if (this.project.getCollectedProjects().size() > 0) {
                this.removeOldElements(modules, "module");
                Iterator i = this.project.getCollectedProjects().iterator();
                while (i.hasNext()) {
                    MavenProject p = (MavenProject)i.next();
                    Xpp3Dom m = IdeaMojo.createElement(modules, "module");
                    String modulePath = new File(p.getBasedir(), p.getArtifactId() + ".iml").getAbsolutePath();
                    m.setAttribute("filepath", "$PROJECT_DIR$/" + IdeaMojo.toRelative(this.project.getBasedir(), modulePath));
                }
            } else {
                Xpp3Dom m = IdeaMojo.createElement(modules, "module");
                String modulePath = new File(this.project.getBasedir(), this.project.getArtifactId() + ".iml").getAbsolutePath();
                m.setAttribute("filepath", "$PROJECT_DIR$/" + IdeaMojo.toRelative(this.project.getBasedir(), modulePath));
            }
            FileWriter writer = new FileWriter(projectFile);
            try {
                Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)module);
            }
            finally {
                IOUtil.close((Writer)writer);
            }
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing existing IPR file: " + projectFile.getAbsolutePath(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error parsing existing IPR file: " + projectFile.getAbsolutePath(), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteModule() throws MojoExecutionException {
        File moduleFile = new File(this.project.getBasedir(), this.project.getArtifactId() + ".iml");
        try {
            String directory;
            Resource resource;
            String directory2;
            Xpp3Dom module;
            InputStreamReader reader = moduleFile.exists() ? new FileReader(moduleFile) : new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/templates/default/module.xml"));
            try {
                module = Xpp3DomBuilder.build((Reader)reader);
            }
            finally {
                IOUtil.close((Reader)reader);
            }
            if ("war".equals(this.project.getPackaging())) {
                this.addWebModule(module);
            } else if ("ejb".equals(this.project.getPackaging())) {
                module.setAttribute("type", "J2EE_EJB_MODULE");
            }
            Xpp3Dom component = this.findComponent(module, "NewModuleRootManager");
            Xpp3Dom output = this.findElement(component, "output");
            output.setAttribute("url", this.getModuleFileUrl(this.project.getBuild().getOutputDirectory()));
            Xpp3Dom outputTest = this.findElement(component, "output-test");
            outputTest.setAttribute("url", this.getModuleFileUrl(this.project.getBuild().getTestOutputDirectory()));
            Xpp3Dom content = this.findElement(component, "content");
            this.removeOldElements(content, "sourceFolder");
            Iterator i = this.executedProject.getCompileSourceRoots().iterator();
            while (i.hasNext()) {
                directory2 = (String)i.next();
                this.addSourceFolder(content, directory2, false);
            }
            i = this.executedProject.getTestCompileSourceRoots().iterator();
            while (i.hasNext()) {
                directory2 = (String)i.next();
                this.addSourceFolder(content, directory2, true);
            }
            i = this.project.getBuild().getResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                directory = resource.getDirectory();
                this.addSourceFolder(content, directory, false);
            }
            i = this.project.getBuild().getTestResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                directory = resource.getDirectory();
                this.addSourceFolder(content, directory, true);
            }
            this.removeOldDependencies(component);
            i = this.project.getArtifacts().iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                Xpp3Dom dep = IdeaMojo.createElement(component, "orderEntry");
                if (a.getFile() != null) {
                    dep.setAttribute("type", "module-library");
                    dep = IdeaMojo.createElement(dep, "library");
                    dep.setAttribute("name", a.getArtifactId());
                    Xpp3Dom el = IdeaMojo.createElement(dep, "CLASSES");
                    el = IdeaMojo.createElement(el, "root");
                    File file = a.getFile();
                    el.setAttribute("url", "jar://" + file.getAbsolutePath().replace('\\', '/') + "!/");
                    IdeaMojo.createElement(dep, "JAVADOC");
                    IdeaMojo.createElement(dep, "SOURCES");
                    continue;
                }
                dep.setAttribute("type", "module");
                dep.setAttribute("module-name", a.getArtifactId());
            }
            FileWriter writer = new FileWriter(moduleFile);
            try {
                Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)module);
            }
            finally {
                IOUtil.close((Writer)writer);
            }
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing existing IML file " + moduleFile.getAbsolutePath(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error parsing existing IML file " + moduleFile.getAbsolutePath(), (Exception)e);
        }
    }

    private void addWebModule(Xpp3Dom module) {
        String warWebapp = this.project.getBuild().getDirectory() + "/" + this.project.getArtifactId();
        String warSrc = "src/main/webapp";
        String webXml = warSrc + "/WEB-INF/web.xml";
        module.setAttribute("type", "J2EE_WEB_MODULE");
        Xpp3Dom component = this.findComponent(module, "WebModuleBuildComponent");
        Xpp3Dom setting = this.findSetting(component, "EXPLODED_URL");
        setting.setAttribute("value", this.getModuleFileUrl(warWebapp));
        component = this.findComponent(module, "WebModuleProperties");
        Xpp3Dom element = this.findElement(component, "deploymentDescriptor");
        if (element.getAttribute("version") == null) {
            // empty if block
        }
        if (element.getAttribute("name") == null) {
            element.setAttribute("name", "web.xml");
        }
        element.setAttribute("url", this.getModuleFileUrl(webXml));
        element = this.findElement(component, "webroots");
        this.removeOldElements(element, "root");
        element = IdeaMojo.createElement(element, "root");
        element.setAttribute("relative", "/");
        element.setAttribute("url", this.getModuleFileUrl(warSrc));
    }

    private void setJdkName(Xpp3Dom content, String jdkName) {
        Xpp3Dom component = this.findComponent(content, "ProjectRootManager");
        component.setAttribute("project-jdk-name", jdkName);
    }

    private void addSourceFolder(Xpp3Dom content, String directory, boolean isTest) {
        if (!StringUtils.isEmpty((String)directory) && new File(directory).isDirectory()) {
            Xpp3Dom sourceFolder = IdeaMojo.createElement(content, "sourceFolder");
            sourceFolder.setAttribute("url", this.getModuleFileUrl(directory));
            sourceFolder.setAttribute("isTestSource", Boolean.toString(isTest));
        }
    }

    private static String toRelative(File basedir, String absolutePath) {
        String relative = absolutePath.startsWith(basedir.getAbsolutePath()) ? absolutePath.substring(basedir.getAbsolutePath().length() + 1) : absolutePath;
        relative = StringUtils.replace((String)relative, (String)"\\", (String)"/");
        return relative;
    }

    private String getModuleFileUrl(String file) {
        return "file://$MODULE_DIR$/" + IdeaMojo.toRelative(this.project.getBasedir(), file);
    }

    private void removeOldElements(Xpp3Dom content, String name) {
        Xpp3Dom[] children = content.getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            Xpp3Dom child = children[i];
            if (!child.getName().equals(name)) continue;
            content.removeChild(i);
        }
    }

    private void removeOldDependencies(Xpp3Dom component) {
        Xpp3Dom[] children = component.getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            Xpp3Dom child = children[i];
            if (!"orderEntry".equals(child.getName()) || !"module-library".equals(child.getAttribute("type"))) continue;
            component.removeChild(i);
        }
    }

    private Xpp3Dom findComponent(Xpp3Dom module, String name) {
        Xpp3Dom[] components = module.getChildren("component");
        for (int i = 0; i < components.length; ++i) {
            if (!name.equals(components[i].getAttribute("name"))) continue;
            return components[i];
        }
        Xpp3Dom component = IdeaMojo.createElement(module, "component");
        component.setAttribute("name", name);
        return component;
    }

    private Xpp3Dom findSetting(Xpp3Dom component, String name) {
        Xpp3Dom[] settings = component.getChildren("setting");
        for (int i = 0; i < settings.length; ++i) {
            if (!name.equals(settings[i].getAttribute("name"))) continue;
            return settings[i];
        }
        Xpp3Dom setting = IdeaMojo.createElement(component, "setting");
        setting.setAttribute("name", name);
        return setting;
    }

    private static Xpp3Dom createElement(Xpp3Dom module, String name) {
        Xpp3Dom component = new Xpp3Dom(name);
        module.addChild(component);
        return component;
    }

    private Xpp3Dom findElement(Xpp3Dom component, String name) {
        Xpp3Dom element = component.getChild(name);
        if (element == null) {
            element = IdeaMojo.createElement(component, name);
        }
        return element;
    }
}

