/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.test.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.test.plugin.TestToolsException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.RepositorySystemSession;

@Component(role=RepositoryTool.class)
public class RepositoryTool
implements Contextualizable {
    public static final String ROLE = RepositoryTool.class.getName();
    @Requirement
    private ArtifactRepositoryFactory repositoryFactory;
    @Requirement
    private MavenSettingsBuilder settingsBuilder;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private ArtifactInstaller artifactInstaller;
    @Requirement
    private LegacySupport legacySupport;
    private PlexusContainer container;

    public File findLocalRepositoryDirectory() throws TestToolsException {
        Settings settings;
        String localRepo = System.getProperty("maven.local.repo");
        if (StringUtils.isNotEmpty((String)localRepo)) {
            return new File(localRepo);
        }
        try {
            DefaultMavenExecutionRequest request = new DefaultMavenExecutionRequest();
            request.setUserSettingsFile(new File(System.getProperty("user.home"), ".m2/settings.xml"));
            request.setGlobalSettingsFile(new File(System.getProperty("maven.home"), "conf/settings.xml"));
            settings = this.settingsBuilder.buildSettings((MavenExecutionRequest)request);
        }
        catch (IOException e) {
            throw new TestToolsException("Error building Maven settings.", e);
        }
        catch (XmlPullParserException e) {
            throw new TestToolsException("Error building Maven settings.", e);
        }
        if (settings == null || settings.getLocalRepository() == null || settings.getLocalRepository().trim().length() < 1) {
            return new File(System.getProperty("user.home"), ".m2/repository");
        }
        return new File(settings.getLocalRepository());
    }

    public ArtifactRepository createLocalArtifactRepositoryInstance() throws TestToolsException {
        File localRepoDir = this.findLocalRepositoryDirectory();
        return this.createLocalArtifactRepositoryInstance(localRepoDir);
    }

    public ArtifactRepository createLocalArtifactRepositoryInstance(File localRepositoryDirectory) throws TestToolsException {
        ArtifactRepositoryLayout defaultLayout;
        try {
            defaultLayout = (ArtifactRepositoryLayout)this.container.lookup(ArtifactRepositoryLayout.ROLE, "default");
        }
        catch (ComponentLookupException e) {
            throw new TestToolsException("Error retrieving default repository layout.", e);
        }
        try {
            return this.repositoryFactory.createArtifactRepository("local", localRepositoryDirectory.toURL().toExternalForm(), defaultLayout, null, null);
        }
        catch (MalformedURLException e) {
            throw new TestToolsException("Error converting local repo directory to a URL.", e);
        }
    }

    public void createLocalRepositoryFromComponentProject(MavenProject project, File realPomFile, File targetLocalRepoBasedir) throws TestToolsException {
        Artifact artifact = project.getArtifact();
        if ("pom".equals(project.getPackaging())) {
            artifact.setFile(project.getFile());
        }
        ArtifactRepository localRepository = this.createLocalArtifactRepositoryInstance(targetLocalRepoBasedir);
        String localPath = localRepository.pathOf(artifact);
        File destination = new File(localRepository.getBasedir(), localPath);
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        this.legacySupport.setSession(new MavenSession(this.container, (RepositorySystemSession)MavenRepositorySystemUtils.newSession(), (MavenExecutionRequest)new DefaultMavenExecutionRequest(), (MavenExecutionResult)new DefaultMavenExecutionResult()));
        try {
            this.artifactInstaller.install(artifact.getFile(), artifact, localRepository);
        }
        catch (ArtifactInstallationException e) {
            throw new TestToolsException("Error installing plugin artifact to target local repository: " + targetLocalRepoBasedir, e);
        }
        finally {
            this.legacySupport.setSession(null);
        }
        this.installLocallyReachableAncestorPoms(realPomFile, localRepository);
    }

    private void installLocallyReachableAncestorPoms(File realPomFile, ArtifactRepository localRepo) throws TestToolsException {
        MavenXpp3Reader pomReader = new MavenXpp3Reader();
        File pom = realPomFile;
        boolean firstPass = true;
        while (pom != null) {
            if (!pom.exists()) {
                pom = null;
                break;
            }
            String pomGroupId = null;
            String pomArtifactId = null;
            String pomVersion = null;
            XmlStreamReader reader = null;
            File currentPom = pom;
            try {
                reader = ReaderFactory.newXmlReader((File)pom);
                Model model = pomReader.read((Reader)reader);
                pomGroupId = model.getGroupId();
                pomArtifactId = model.getArtifactId();
                pomVersion = model.getVersion();
                Parent parent = model.getParent();
                if (parent != null) {
                    pom = new File(pom.getParentFile(), parent.getRelativePath());
                    if (pomGroupId == null) {
                        pomGroupId = parent.getGroupId();
                    }
                    if (pomVersion == null) {
                        pomVersion = parent.getVersion();
                    }
                } else {
                    pom = null;
                }
            }
            catch (IOException e) {
                throw new TestToolsException("Error reading ancestor POM: " + currentPom, e);
            }
            catch (XmlPullParserException e) {
                throw new TestToolsException("Error reading ancestor POM: " + currentPom, e);
            }
            finally {
                IOUtil.close((Reader)reader);
            }
            if (!firstPass) {
                Artifact pomArtifact = this.artifactFactory.createProjectArtifact(pomGroupId, pomArtifactId, pomVersion);
                pomArtifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(pomArtifact, currentPom));
                try {
                    this.artifactInstaller.install(currentPom, pomArtifact, localRepo);
                    continue;
                }
                catch (ArtifactInstallationException e) {
                    throw new TestToolsException("Error installing ancestor POM: " + currentPom + " to target local repository: " + localRepo.getBasedir(), e);
                }
            }
            firstPass = false;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

