/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.di.testing;

import java.io.File;
import org.apache.maven.di.Injector;
import org.apache.maven.di.Key;
import org.apache.maven.di.impl.DIException;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class MavenDIExtension
implements BeforeEachCallback,
AfterEachCallback {
    protected static ExtensionContext context;
    protected Injector injector;
    protected static String basedir;

    public void beforeEach(ExtensionContext context) throws Exception {
        basedir = MavenDIExtension.getBasedir();
        this.setContext(context);
        this.getInjector().bindInstance(context.getRequiredTestClass(), context.getRequiredTestInstance());
        this.getInjector().injectInstance(context.getRequiredTestInstance());
    }

    protected void setContext(ExtensionContext context) {
        MavenDIExtension.context = context;
    }

    protected void setupContainer() {
        try {
            this.injector = Injector.create();
            this.injector.bindInstance(ExtensionContext.class, (Object)context);
            this.injector.discover(context.getRequiredTestClass().getClassLoader());
            this.injector.bindInstance(Injector.class, (Object)this.injector);
            this.injector.bindInstance(context.getRequiredTestClass(), context.getRequiredTestInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create DI injector.", e);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (this.injector != null) {
            this.injector = null;
        }
    }

    public Injector getInjector() {
        if (this.injector == null) {
            this.setupContainer();
        }
        return this.injector;
    }

    protected <T> T lookup(Class<T> componentClass) throws DIException {
        return (T)this.getInjector().getInstance(componentClass);
    }

    protected <T> T lookup(Class<T> componentClass, String roleHint) throws DIException {
        return (T)this.getInjector().getInstance(Key.ofType(componentClass, (Object)roleHint));
    }

    protected <T> T lookup(Class<T> componentClass, Object qualifier) throws DIException {
        return (T)this.getInjector().getInstance(Key.ofType(componentClass, (Object)qualifier));
    }

    protected void release(Object component) throws DIException {
    }

    public static File getTestFile(String path) {
        return new File(MavenDIExtension.getBasedir(), path);
    }

    public static File getTestFile(String basedir, String path) {
        File basedirFile = new File(basedir);
        if (!basedirFile.isAbsolute()) {
            basedirFile = MavenDIExtension.getTestFile(basedir);
        }
        return new File(basedirFile, path);
    }

    public static String getTestPath(String path) {
        return MavenDIExtension.getTestFile(path).getAbsolutePath();
    }

    public static String getTestPath(String basedir, String path) {
        return MavenDIExtension.getTestFile(basedir, path).getAbsolutePath();
    }

    public static String getBasedir() {
        if (basedir != null) {
            return basedir;
        }
        basedir = System.getProperty("basedir");
        if (basedir == null) {
            basedir = new File("").getAbsolutePath();
        }
        return basedir;
    }
}

