/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing.stubs;

import java.util.Objects;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.ArtifactCoordinate;
import org.apache.maven.api.Version;
import org.apache.maven.api.VersionRange;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.internal.impl.DefaultVersionParser;

public class ArtifactStub
implements Artifact {
    private String groupId;
    private String artifactId;
    private String classifier;
    private String version;
    private String extension;

    public ArtifactStub() {
        this.groupId = "";
        this.artifactId = "";
        this.version = "";
        this.classifier = "";
        this.extension = "";
    }

    public ArtifactStub(String groupId, String artifactId, String classifier, String version, String extension) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.version = version;
        this.extension = extension;
    }

    @Nonnull
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Nonnull
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Nonnull
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Nonnull
    public Version getVersion() {
        return new DefaultVersionParser().parseVersion(this.version);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Nonnull
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public boolean isSnapshot() {
        return false;
    }

    public ArtifactCoordinate toCoordinate() {
        return new ArtifactCoordinate(){

            public String getGroupId() {
                return ArtifactStub.this.groupId;
            }

            public String getArtifactId() {
                return ArtifactStub.this.artifactId;
            }

            public String getClassifier() {
                return ArtifactStub.this.classifier;
            }

            public VersionRange getVersion() {
                return new DefaultVersionParser().parseVersionRange(ArtifactStub.this.version);
            }

            public String getExtension() {
                return ArtifactStub.this.extension;
            }
        };
    }

    public String toString() {
        return "ArtifactStub[groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", classifier='" + this.classifier + '\'' + ", version='" + this.version + '\'' + ", extension='" + this.extension + '\'' + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArtifactStub)) {
            return false;
        }
        ArtifactStub that = (ArtifactStub)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.version, that.version) && Objects.equals(this.extension, that.extension);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.classifier, this.version, this.extension);
    }
}

