/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing.stubs;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.LocalRepository;
import org.apache.maven.api.Project;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.model.Repository;
import org.apache.maven.api.plugin.testing.stubs.ArtifactStub;
import org.apache.maven.api.plugin.testing.stubs.ProjectStub;
import org.apache.maven.api.services.ArtifactDeployer;
import org.apache.maven.api.services.ArtifactDeployerRequest;
import org.apache.maven.api.services.ArtifactFactory;
import org.apache.maven.api.services.ArtifactFactoryRequest;
import org.apache.maven.api.services.ArtifactInstaller;
import org.apache.maven.api.services.ArtifactInstallerRequest;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.LocalRepositoryManager;
import org.apache.maven.api.services.ProjectBuilder;
import org.apache.maven.api.services.ProjectBuilderRequest;
import org.apache.maven.api.services.ProjectBuilderResult;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.api.services.RepositoryFactory;
import org.apache.maven.api.services.Source;
import org.apache.maven.api.services.xml.ModelXmlFactory;
import org.apache.maven.internal.impl.DefaultModelXmlFactory;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;

public class SessionStub {
    public static Session getMockSession(String localRepo) {
        LocalRepository localRepository = (LocalRepository)Mockito.mock(LocalRepository.class);
        Mockito.when((Object)localRepository.getId()).thenReturn((Object)"local");
        Mockito.when((Object)localRepository.getPath()).thenReturn((Object)Paths.get(localRepo, new String[0]));
        return SessionStub.getMockSession(localRepository);
    }

    public static Session getMockSession(LocalRepository localRepository) {
        Session session = (Session)Mockito.mock(Session.class);
        RepositoryFactory repositoryFactory = (RepositoryFactory)Mockito.mock(RepositoryFactory.class);
        Mockito.when((Object)repositoryFactory.createRemote((Repository)ArgumentMatchers.any(Repository.class))).thenAnswer(iom -> {
            Repository repository = (Repository)iom.getArgument(0, Repository.class);
            return repositoryFactory.createRemote(repository.getId(), repository.getUrl());
        });
        Mockito.when((Object)repositoryFactory.createRemote(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(iom -> {
            String id = (String)iom.getArgument(0, String.class);
            String url = (String)iom.getArgument(1, String.class);
            RemoteRepository remoteRepository = (RemoteRepository)Mockito.mock(RemoteRepository.class, (MockSettings)Mockito.withSettings().lenient());
            Mockito.when((Object)remoteRepository.getId()).thenReturn((Object)id);
            Mockito.when((Object)remoteRepository.getUrl()).thenReturn((Object)url);
            Mockito.when((Object)remoteRepository.getProtocol()).thenReturn((Object)URI.create(url).getScheme());
            return remoteRepository;
        });
        LocalRepositoryManager localRepositoryManager = (LocalRepositoryManager)Mockito.mock(LocalRepositoryManager.class);
        Mockito.when((Object)localRepositoryManager.getPathForLocalArtifact((Session)ArgumentMatchers.any(), (LocalRepository)ArgumentMatchers.any(), (Artifact)ArgumentMatchers.any())).thenAnswer(iom -> {
            LocalRepository localRepo = (LocalRepository)iom.getArgument(1, LocalRepository.class);
            Artifact artifact = (Artifact)iom.getArgument(2, Artifact.class);
            return localRepo.getPath().resolve(SessionStub.getPathForArtifact(artifact, true));
        });
        ArtifactInstaller artifactInstaller = (ArtifactInstaller)Mockito.mock(ArtifactInstaller.class);
        ((ArtifactInstaller)Mockito.doAnswer(iom -> {
            artifactInstaller.install(ArtifactInstallerRequest.build((Session)((Session)iom.getArgument(0, Session.class)), (Collection)((Collection)iom.getArgument(1, Collection.class))));
            return null;
        }).when((Object)artifactInstaller)).install((Session)ArgumentMatchers.any(Session.class), (Collection)ArgumentMatchers.any());
        ArtifactDeployer artifactDeployer = (ArtifactDeployer)Mockito.mock(ArtifactDeployer.class);
        ((ArtifactDeployer)Mockito.doAnswer(iom -> {
            artifactDeployer.deploy(ArtifactDeployerRequest.build((Session)((Session)iom.getArgument(0, Session.class)), (RemoteRepository)((RemoteRepository)iom.getArgument(1, RemoteRepository.class)), (Collection)((Collection)iom.getArgument(2, Collection.class))));
            return null;
        }).when((Object)artifactDeployer)).deploy((Session)ArgumentMatchers.any(), (RemoteRepository)ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        ArtifactManager artifactManager = (ArtifactManager)Mockito.mock(ArtifactManager.class);
        HashMap paths = new HashMap();
        ((ArtifactManager)Mockito.doAnswer(iom -> {
            paths.put((Artifact)iom.getArgument(0), (Path)iom.getArgument(1));
            return null;
        }).when((Object)artifactManager)).setPath((Artifact)ArgumentMatchers.any(), (Path)ArgumentMatchers.any());
        ((ArtifactManager)Mockito.doAnswer(iom -> Optional.ofNullable((Path)paths.get(iom.getArgument(0, Artifact.class)))).when((Object)artifactManager)).getPath((Artifact)ArgumentMatchers.any());
        ProjectManager projectManager = (ProjectManager)Mockito.mock(ProjectManager.class);
        HashMap attachedArtifacts = new HashMap();
        ((ProjectManager)Mockito.doAnswer(iom -> {
            Project project = (Project)iom.getArgument(1, Project.class);
            String type = (String)iom.getArgument(2, String.class);
            Path path = (Path)iom.getArgument(3, Path.class);
            Artifact artifact = session.createArtifact(project.getGroupId(), project.getArtifactId(), project.getVersion(), null, null, type);
            artifactManager.setPath(artifact, path);
            attachedArtifacts.computeIfAbsent(project, p -> new ArrayList()).add(artifact);
            return null;
        }).when((Object)projectManager)).attachArtifact((Session)ArgumentMatchers.same((Object)session), (Project)ArgumentMatchers.any(Project.class), (String)ArgumentMatchers.any(), (Path)ArgumentMatchers.any());
        ((ProjectManager)Mockito.doAnswer(iom -> {
            Project project = (Project)iom.getArgument(0, Project.class);
            Artifact artifact = (Artifact)iom.getArgument(1, Artifact.class);
            Path path = (Path)iom.getArgument(2, Path.class);
            artifactManager.setPath(artifact, path);
            attachedArtifacts.computeIfAbsent(project, p -> new ArrayList()).add(artifact);
            return null;
        }).when((Object)projectManager)).attachArtifact((Project)ArgumentMatchers.any(Project.class), (Artifact)ArgumentMatchers.any(Artifact.class), (Path)ArgumentMatchers.any(Path.class));
        Mockito.when((Object)projectManager.getAttachedArtifacts((Project)ArgumentMatchers.any())).then(iom -> attachedArtifacts.computeIfAbsent((Project)iom.getArgument(0, Project.class), p -> new ArrayList()));
        ArtifactFactory artifactFactory = (ArtifactFactory)Mockito.mock(ArtifactFactory.class);
        Mockito.when((Object)artifactFactory.create((ArtifactFactoryRequest)ArgumentMatchers.any())).then(iom -> {
            ArtifactFactoryRequest request = (ArtifactFactoryRequest)iom.getArgument(0, ArtifactFactoryRequest.class);
            String classifier = request.getClassifier();
            String extension = request.getExtension();
            String type = request.getType();
            if (classifier == null) {
                classifier = "";
            }
            if (extension == null) {
                extension = type != null ? type : "";
            }
            return new ArtifactStub(request.getGroupId(), request.getArtifactId(), classifier, request.getVersion(), extension);
        });
        ProjectBuilder projectBuilder = (ProjectBuilder)Mockito.mock(ProjectBuilder.class);
        Mockito.when((Object)projectBuilder.build((ProjectBuilderRequest)ArgumentMatchers.any(ProjectBuilderRequest.class))).then(iom -> {
            ProjectBuilderRequest request = (ProjectBuilderRequest)iom.getArgument(0, ProjectBuilderRequest.class);
            ProjectBuilderResult result = (ProjectBuilderResult)Mockito.mock(ProjectBuilderResult.class);
            Model model = new MavenXpp3Reader().read(((Source)request.getSource().get()).getInputStream()).getDelegate();
            ProjectStub projectStub = new ProjectStub();
            projectStub.setModel(model);
            ArtifactStub artifactStub = new ArtifactStub(model.getGroupId(), model.getArtifactId(), "", model.getVersion(), model.getPackaging());
            projectStub.setArtifact(artifactStub);
            Mockito.when((Object)result.getProject()).thenReturn(Optional.of(projectStub));
            return result;
        });
        Properties sysProps = new Properties();
        Properties usrProps = new Properties();
        ((Session)Mockito.doReturn((Object)sysProps).when((Object)session)).getSystemProperties();
        ((Session)Mockito.doReturn((Object)usrProps).when((Object)session)).getUserProperties();
        Mockito.when((Object)session.getLocalRepository()).thenReturn((Object)localRepository);
        Mockito.when((Object)((RepositoryFactory)session.getService(RepositoryFactory.class))).thenReturn((Object)repositoryFactory);
        Mockito.when((Object)((ProjectBuilder)session.getService(ProjectBuilder.class))).thenReturn((Object)projectBuilder);
        Mockito.when((Object)((LocalRepositoryManager)session.getService(LocalRepositoryManager.class))).thenReturn((Object)localRepositoryManager);
        Mockito.when((Object)((ProjectManager)session.getService(ProjectManager.class))).thenReturn((Object)projectManager);
        Mockito.when((Object)((ArtifactManager)session.getService(ArtifactManager.class))).thenReturn((Object)artifactManager);
        Mockito.when((Object)((ArtifactInstaller)session.getService(ArtifactInstaller.class))).thenReturn((Object)artifactInstaller);
        Mockito.when((Object)((ArtifactDeployer)session.getService(ArtifactDeployer.class))).thenReturn((Object)artifactDeployer);
        Mockito.when((Object)((ArtifactFactory)session.getService(ArtifactFactory.class))).thenReturn((Object)artifactFactory);
        Mockito.when((Object)((ModelXmlFactory)session.getService(ModelXmlFactory.class))).thenReturn((Object)new DefaultModelXmlFactory());
        Mockito.when((Object)session.getPathForLocalArtifact((Artifact)ArgumentMatchers.any(Artifact.class))).then(iom -> localRepositoryManager.getPathForLocalArtifact(session, session.getLocalRepository(), (Artifact)iom.getArgument(0, Artifact.class)));
        Mockito.when((Object)session.createArtifact((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenAnswer(iom -> {
            String groupId = (String)iom.getArgument(0, String.class);
            String artifactId = (String)iom.getArgument(1, String.class);
            String version = (String)iom.getArgument(2, String.class);
            String classifier = (String)iom.getArgument(3, String.class);
            String extension = (String)iom.getArgument(4, String.class);
            String type = (String)iom.getArgument(5, String.class);
            return ((ArtifactFactory)session.getService(ArtifactFactory.class)).create(ArtifactFactoryRequest.builder().session(session).groupId(groupId).artifactId(artifactId).version(version).classifier(classifier).extension(extension).type(type).build());
        });
        Mockito.when((Object)session.createArtifact((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenAnswer(iom -> {
            String groupId = (String)iom.getArgument(0, String.class);
            String artifactId = (String)iom.getArgument(1, String.class);
            String version = (String)iom.getArgument(2, String.class);
            String extension = (String)iom.getArgument(3, String.class);
            return ((ArtifactFactory)session.getService(ArtifactFactory.class)).create(ArtifactFactoryRequest.builder().session(session).groupId(groupId).artifactId(artifactId).version(version).extension(extension).build());
        });
        Mockito.when((Object)session.createRemoteRepository(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenAnswer(iom -> {
            String id = (String)iom.getArgument(0, String.class);
            String url = (String)iom.getArgument(1, String.class);
            return ((RepositoryFactory)session.getService(RepositoryFactory.class)).createRemote(id, url);
        });
        ((Session)Mockito.doAnswer(iom -> artifactManager.getPath((Artifact)iom.getArgument(0, Artifact.class))).when((Object)session)).getArtifactPath((Artifact)ArgumentMatchers.any());
        Mockito.when((Object)session.withLocalRepository((LocalRepository)ArgumentMatchers.any())).thenAnswer(iom -> SessionStub.getMockSession((LocalRepository)iom.getArgument(0, LocalRepository.class)));
        return session;
    }

    static String getPathForArtifact(Artifact artifact, boolean local) {
        StringBuilder path = new StringBuilder(128);
        path.append(artifact.getGroupId().replace('.', '/')).append('/');
        path.append(artifact.getArtifactId()).append('/');
        path.append(artifact.getVersion()).append('/');
        path.append(artifact.getArtifactId()).append('-');
        path.append(artifact.getVersion());
        if (artifact.getClassifier().length() > 0) {
            path.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            path.append('.').append(artifact.getExtension());
        }
        return path.toString();
    }
}

