/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.testing;

import com.google.inject.Module;
import com.google.inject.internal.ProviderMethodsModule;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.MojoExecution;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.plugin.Log;
import org.apache.maven.api.plugin.Mojo;
import org.apache.maven.api.plugin.testing.ConfigurationException;
import org.apache.maven.api.plugin.testing.InjectMojo;
import org.apache.maven.api.plugin.testing.MojoParameter;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.configuration.internal.EnhancedComponentConfigurator;
import org.apache.maven.internal.impl.DefaultLog;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.PluginParameterExpressionEvaluatorV4;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.testing.PlexusExtension;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.LoggerFactory;

public class MojoExtension
extends PlexusExtension
implements ParameterResolver {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(InjectMojo.class) || parameterContext.getDeclaringExecutable().isAnnotationPresent(InjectMojo.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        try {
            InjectMojo injectMojo = parameterContext.findAnnotation(InjectMojo.class).orElseGet(() -> parameterContext.getDeclaringExecutable().getAnnotation(InjectMojo.class));
            List mojoParameters = parameterContext.findRepeatableAnnotations(MojoParameter.class);
            Class<?> holder = parameterContext.getTarget().get().getClass();
            PluginDescriptor descriptor = (PluginDescriptor)extensionContext.getStore(ExtensionContext.Namespace.GLOBAL).get(PluginDescriptor.class, PluginDescriptor.class);
            return this.lookupMojo(holder, injectMojo, mojoParameters, descriptor);
        }
        catch (Exception e) {
            throw new ParameterResolutionException("Unable to resolve parameter", (Throwable)e);
        }
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        Field field = PlexusExtension.class.getDeclaredField("basedir");
        field.setAccessible(true);
        field.set(null, MojoExtension.getBasedir());
        field = PlexusExtension.class.getDeclaredField("context");
        field.setAccessible(true);
        field.set((Object)this, context);
        this.getContainer().addComponent((Object)this.getContainer(), PlexusContainer.class.getName());
        ((DefaultPlexusContainer)this.getContainer()).addPlexusInjector(Collections.emptyList(), new Module[]{binder -> {
            binder.install(ProviderMethodsModule.forObject((Object)context.getRequiredTestInstance()));
            binder.requestInjection(context.getRequiredTestInstance());
            binder.bind(Log.class).toInstance((Object)new DefaultLog(LoggerFactory.getLogger((String)"anonymous")));
        }});
        Map map = this.getContainer().getContext().getContextData();
        ClassLoader classLoader = context.getRequiredTestClass().getClassLoader();
        try (InputStream is = Objects.requireNonNull(classLoader.getResourceAsStream(this.getPluginDescriptorLocation()), "Unable to find plugin descriptor: " + this.getPluginDescriptorLocation());
             BufferedReader reader = new BufferedReader((Reader)new XmlStreamReader(is));
             InterpolationFilterReader interpolationReader = new InterpolationFilterReader((Reader)reader, map, "${", "}");){
            PluginDescriptor pluginDescriptor = new PluginDescriptorBuilder().build((Reader)interpolationReader);
            context.getStore(ExtensionContext.Namespace.GLOBAL).put(PluginDescriptor.class, (Object)pluginDescriptor);
            for (ComponentDescriptor desc : pluginDescriptor.getComponents()) {
                this.getContainer().addComponentDescriptor(desc);
            }
        }
    }

    protected String getPluginDescriptorLocation() {
        return "META-INF/maven/plugin.xml";
    }

    private Mojo lookupMojo(Class<?> holder, InjectMojo injectMojo, List<MojoParameter> mojoParameters, PluginDescriptor descriptor) throws Exception {
        Xpp3Dom pomDom;
        Path path;
        String goal = injectMojo.goal();
        String pom = injectMojo.pom();
        String[] coord = this.mojoCoordinates(goal);
        if (pom.startsWith("file:")) {
            path = Paths.get(MojoExtension.getBasedir(), new String[0]).resolve(pom.substring("file:".length()));
            pomDom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((File)path.toFile()));
        } else if (pom.startsWith("classpath:")) {
            URL url = holder.getResource(pom.substring("classpath:".length()));
            if (url == null) {
                throw new IllegalStateException("Unable to find pom on classpath: " + pom);
            }
            pomDom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((InputStream)url.openStream()));
        } else if (pom.contains("<project>")) {
            pomDom = Xpp3DomBuilder.build((Reader)new StringReader(pom));
        } else {
            path = Paths.get(MojoExtension.getBasedir(), new String[0]).resolve(pom);
            pomDom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((File)path.toFile()));
        }
        XmlNode pluginConfiguration = MojoExtension.extractPluginConfiguration(coord[1], pomDom);
        if (!mojoParameters.isEmpty()) {
            List children = mojoParameters.stream().map(mp -> new XmlNodeImpl(mp.name(), mp.value())).collect(Collectors.toList());
            XmlNodeImpl config = new XmlNodeImpl("configuration", null, null, children, null);
            pluginConfiguration = XmlNode.merge((XmlNode)config, (XmlNode)pluginConfiguration);
        }
        Mojo mojo = this.lookupMojo(coord, pluginConfiguration, descriptor);
        return mojo;
    }

    protected String[] mojoCoordinates(String goal) throws Exception {
        if (goal.matches(".*:.*:.*:.*")) {
            return goal.split(":");
        }
        Path pluginPom = Paths.get(MojoExtension.getBasedir(), "pom.xml");
        Xpp3Dom pluginPomDom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((File)pluginPom.toFile()));
        String artifactId = pluginPomDom.getChild("artifactId").getValue();
        String groupId = MojoExtension.resolveFromRootThenParent(pluginPomDom, "groupId");
        String version = MojoExtension.resolveFromRootThenParent(pluginPomDom, "version");
        return new String[]{groupId, artifactId, version, goal};
    }

    protected Mojo lookupMojo(String[] coord, XmlNode pluginConfiguration, PluginDescriptor descriptor) throws Exception {
        Mojo mojo = (Mojo)this.lookup(Mojo.class, coord[0] + ":" + coord[1] + ":" + coord[2] + ":" + coord[3]);
        for (MojoDescriptor mojoDescriptor : descriptor.getMojos()) {
            if (!Objects.equals(mojoDescriptor.getImplementation(), mojo.getClass().getName()) || pluginConfiguration == null) continue;
            pluginConfiguration = this.finalizeConfig(pluginConfiguration, mojoDescriptor);
        }
        if (pluginConfiguration != null) {
            org.apache.maven.plugin.MojoExecution mojoExecution;
            Project project;
            Session session = (Session)this.getContainer().lookup(Session.class);
            try {
                project = (Project)this.getContainer().lookup(Project.class);
            }
            catch (ComponentLookupException e) {
                project = null;
            }
            try {
                MojoExecution me = (MojoExecution)this.getContainer().lookup(MojoExecution.class);
                mojoExecution = new org.apache.maven.plugin.MojoExecution(new Plugin(me.getPlugin()), me.getGoal(), me.getExecutionId());
            }
            catch (ComponentLookupException e) {
                mojoExecution = null;
            }
            WrapEvaluator evaluator = new WrapEvaluator(this.getContainer(), (TypeAwareExpressionEvaluator)new PluginParameterExpressionEvaluatorV4(session, project, mojoExecution));
            EnhancedComponentConfigurator configurator = new EnhancedComponentConfigurator();
            configurator.configureComponent((Object)mojo, (PlexusConfiguration)new XmlPlexusConfiguration(new Xpp3Dom(pluginConfiguration)), (ExpressionEvaluator)evaluator, this.getContainer().getContainerRealm());
        }
        return mojo;
    }

    private XmlNode finalizeConfig(XmlNode config, MojoDescriptor mojoDescriptor) {
        ArrayList<XmlNode> children = new ArrayList<XmlNode>();
        if (mojoDescriptor != null && mojoDescriptor.getParameters() != null) {
            XmlNode defaultConfiguration = MojoDescriptorCreator.convert((MojoDescriptor)mojoDescriptor).getDom();
            for (Parameter parameter : mojoDescriptor.getParameters()) {
                XmlNode parameterDefaults;
                XmlNode parameterConfiguration = config.getChild(parameter.getName());
                if (parameterConfiguration == null) {
                    parameterConfiguration = config.getChild(parameter.getAlias());
                }
                if ((parameterConfiguration = XmlNode.merge((XmlNode)parameterConfiguration, (XmlNode)(parameterDefaults = defaultConfiguration.getChild(parameter.getName())), (Boolean)Boolean.TRUE)) == null) continue;
                HashMap<String, String> attributes = new HashMap<String, String>(parameterConfiguration.getAttributes());
                if (this.isEmpty(parameterConfiguration.getAttribute("implementation")) && !this.isEmpty(parameter.getImplementation())) {
                    attributes.put("implementation", parameter.getImplementation());
                }
                parameterConfiguration = new XmlNodeImpl(parameter.getName(), parameterConfiguration.getValue(), attributes, parameterConfiguration.getChildren(), parameterConfiguration.getInputLocation());
                children.add(parameterConfiguration);
            }
        }
        return new XmlNodeImpl("configuration", null, null, children, null);
    }

    private boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static Optional<Xpp3Dom> child(Xpp3Dom element, String name) {
        return Optional.ofNullable(element.getChild(name));
    }

    private static Stream<Xpp3Dom> children(Xpp3Dom element) {
        return Stream.of(element.getChildren());
    }

    public static XmlNode extractPluginConfiguration(String artifactId, Xpp3Dom pomDom) throws Exception {
        Xpp3Dom pluginConfigurationElement = (Xpp3Dom)MojoExtension.child(pomDom, "build").flatMap(buildElement -> MojoExtension.child(buildElement, "plugins")).map(MojoExtension::children).orElseGet(Stream::empty).filter(e -> e.getChild("artifactId").getValue().equals(artifactId)).findFirst().flatMap(buildElement -> MojoExtension.child(buildElement, "configuration")).orElseThrow(() -> new ConfigurationException("Cannot find a configuration element for a plugin with an artifactId of " + artifactId + "."));
        return pluginConfigurationElement.getDom();
    }

    private static String resolveFromRootThenParent(Xpp3Dom pluginPomDom, String element) throws Exception {
        return Optional.ofNullable(MojoExtension.child(pluginPomDom, element).orElseGet(() -> MojoExtension.child(pluginPomDom, "parent").flatMap(e -> MojoExtension.child(e, element)).orElse(null))).map(Xpp3Dom::getValue).orElseThrow(() -> new Exception("unable to determine " + element));
    }

    public static Object getVariableValueFromObject(Object object, String variable) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        field.setAccessible(true);
        return field.get(object);
    }

    public static Map<String, Object> getVariablesAndValuesFromObject(Object object) throws IllegalAccessException {
        return MojoExtension.getVariablesAndValuesFromObject(object.getClass(), object);
    }

    public static Map<String, Object> getVariablesAndValuesFromObject(Class<?> clazz, Object object) throws IllegalAccessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        AccessibleObject[] fields = clazz.getDeclaredFields();
        AccessibleObject.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            map.put(((Field)field).getName(), ((Field)field).get(object));
        }
        Class<?> superclass = clazz.getSuperclass();
        if (!Object.class.equals(superclass)) {
            map.putAll(MojoExtension.getVariablesAndValuesFromObject(superclass, object));
        }
        return map;
    }

    public static void setVariableValueToObject(Object object, String variable, Object value) throws IllegalAccessException {
        Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)variable, object.getClass());
        Objects.requireNonNull(field, "Field " + variable + " not found");
        field.setAccessible(true);
        field.set(object, value);
    }

    static class WrapEvaluator
    implements TypeAwareExpressionEvaluator {
        private final PlexusContainer container;
        private final TypeAwareExpressionEvaluator evaluator;

        WrapEvaluator(PlexusContainer container, TypeAwareExpressionEvaluator evaluator) {
            this.container = container;
            this.evaluator = evaluator;
        }

        public Object evaluate(String expression) throws ExpressionEvaluationException {
            return this.evaluate(expression, null);
        }

        public Object evaluate(String expression, Class<?> type) throws ExpressionEvaluationException {
            String expr;
            Object value = this.evaluator.evaluate(expression, type);
            if (value == null && (expr = this.stripTokens(expression)) != null) {
                try {
                    value = this.container.lookup(type, expr);
                }
                catch (ComponentLookupException componentLookupException) {
                    // empty catch block
                }
            }
            return value;
        }

        private String stripTokens(String expr) {
            if (expr.startsWith("${") && expr.endsWith("}")) {
                return expr.substring(2, expr.length() - 1);
            }
            return null;
        }

        public File alignToBaseDirectory(File path) {
            return this.evaluator.alignToBaseDirectory(path);
        }
    }
}

