/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.xml;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.api.xml.XmlNode;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;

public class XmlNodeWriter {
    public static void write(Writer writer, XmlNode dom) {
        XmlNodeWriter.write(new PrettyPrintXMLWriter(writer), dom);
    }

    public static void write(PrintWriter writer, XmlNode dom) {
        XmlNodeWriter.write(new PrettyPrintXMLWriter(writer), dom);
    }

    public static void write(XMLWriter xmlWriter, XmlNode dom) {
        XmlNodeWriter.write(xmlWriter, dom, true);
    }

    public static void write(XMLWriter xmlWriter, XmlNode dom, boolean escape) {
        xmlWriter.startElement(dom.getName());
        for (Map.Entry<String, String> attr : dom.getAttributes().entrySet()) {
            xmlWriter.addAttribute(attr.getKey(), attr.getValue());
        }
        for (XmlNode aChildren : dom.getChildren()) {
            XmlNodeWriter.write(xmlWriter, aChildren, escape);
        }
        String value = dom.getValue();
        if (value != null) {
            if (escape) {
                xmlWriter.writeText(value);
            } else {
                xmlWriter.writeMarkup(value);
            }
        }
        xmlWriter.endElement();
    }
}

