/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal.scopes;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.repository.internal.scopes.MavenDependencyScopes;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.util.graph.transformer.ConflictResolver;

public final class MavenScopeSelector
extends ConflictResolver.ScopeSelector {
    public void selectScope(ConflictResolver.ConflictContext context) throws RepositoryException {
        String scope = context.getWinner().getDependency().getScope();
        if (!MavenDependencyScopes.SYSTEM.equals(scope)) {
            scope = this.chooseEffectiveScope(context.getItems());
        }
        context.setScope(scope);
    }

    private String chooseEffectiveScope(Collection<ConflictResolver.ConflictItem> items) {
        HashSet<String> scopes = new HashSet<String>();
        for (ConflictResolver.ConflictItem item : items) {
            if (item.getDepth() <= 1) {
                return item.getDependency().getScope();
            }
            scopes.addAll(item.getScopes());
        }
        return this.chooseEffectiveScope((Set<String>)scopes);
    }

    private String chooseEffectiveScope(Set<String> scopes) {
        if (scopes.size() > 1) {
            scopes.remove(MavenDependencyScopes.SYSTEM);
        }
        String effectiveScope = "";
        if (scopes.size() == 1) {
            effectiveScope = scopes.iterator().next();
        } else if (scopes.contains(MavenDependencyScopes.COMPILE)) {
            effectiveScope = MavenDependencyScopes.COMPILE;
        } else if (scopes.contains(MavenDependencyScopes.RUNTIME)) {
            effectiveScope = MavenDependencyScopes.RUNTIME;
        } else if (scopes.contains(MavenDependencyScopes.PROVIDED)) {
            effectiveScope = MavenDependencyScopes.PROVIDED;
        } else if (scopes.contains(MavenDependencyScopes.TEST)) {
            effectiveScope = MavenDependencyScopes.TEST;
        }
        return effectiveScope;
    }
}

