/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal.scopes;

import java.util.Objects;
import org.apache.maven.repository.internal.scopes.MavenDependencyScopes;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.collection.DependencyGraphTransformationContext;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

public final class MavenDependencyContextRefiner
implements DependencyGraphTransformer {
    public DependencyNode transformGraph(DependencyNode node, DependencyGraphTransformationContext context) throws RepositoryException {
        String scope;
        Objects.requireNonNull(node, "node cannot be null");
        Objects.requireNonNull(context, "context cannot be null");
        Object ctx = node.getRequestContext();
        if ("project".equals(ctx) && (scope = this.getBuildpathScope(node)) != null) {
            ctx = (String)ctx + "/" + scope;
            node.setRequestContext((String)ctx);
        }
        for (DependencyNode child : node.getChildren()) {
            this.transformGraph(child, context);
        }
        return node;
    }

    private String getBuildpathScope(DependencyNode node) {
        Dependency dependency = node.getDependency();
        if (dependency == null) {
            return null;
        }
        String scope = dependency.getScope();
        if (MavenDependencyScopes.COMPILE.equals(scope) || MavenDependencyScopes.SYSTEM.equals(scope) || MavenDependencyScopes.PROVIDED.equals(scope)) {
            return MavenDependencyScopes.COMPILE;
        }
        if (MavenDependencyScopes.RUNTIME.equals(scope)) {
            return MavenDependencyScopes.RUNTIME;
        }
        if (MavenDependencyScopes.TEST.equals(scope)) {
            return MavenDependencyScopes.TEST;
        }
        return null;
    }
}

