/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.internal;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.internal.xml.XmlNodeBuilder;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.repository.internal.PluginsMetadata;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.ConfigUtils;

class PluginsMetadataGenerator
implements MetadataGenerator {
    private static final String PLUGIN_DESCRIPTOR_LOCATION = "META-INF/maven/plugin.xml";
    private final Map<Object, PluginsMetadata> processedPlugins = new LinkedHashMap<Object, PluginsMetadata>();
    private final Date timestamp;

    PluginsMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this(session, request.getMetadata());
    }

    PluginsMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this(session, request.getMetadata());
    }

    private PluginsMetadataGenerator(RepositorySystemSession session, Collection<? extends Metadata> metadatas) {
        this.timestamp = (Date)ConfigUtils.getObject((RepositorySystemSession)session, (Object)new Date(), (String[])new String[]{"maven.startTime"});
        Iterator<? extends Metadata> it = metadatas.iterator();
        while (it.hasNext()) {
            Metadata metadata = it.next();
            if (!(metadata instanceof PluginsMetadata)) continue;
            it.remove();
            PluginsMetadata pluginMetadata = (PluginsMetadata)metadata;
            this.processedPlugins.put(pluginMetadata.getGroupId(), pluginMetadata);
        }
    }

    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }

    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        LinkedHashMap<String, PluginsMetadata> plugins = new LinkedHashMap<String, PluginsMetadata>();
        for (Artifact artifact : artifacts) {
            PluginsMetadata pluginMetadata;
            String key;
            PluginsMetadata.PluginInfo pluginInfo = this.extractPluginInfo(artifact);
            if (pluginInfo == null || this.processedPlugins.get(key = pluginInfo.groupId) != null || (pluginMetadata = (PluginsMetadata)((Object)plugins.get(key))) != null) continue;
            pluginMetadata = new PluginsMetadata(pluginInfo, this.timestamp);
            plugins.put(key, pluginMetadata);
        }
        return plugins.values();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private PluginsMetadata.PluginInfo extractPluginInfo(Artifact artifact) {
        block14: {
            Path artifactPath;
            if (artifact != null && "jar".equals(artifact.getExtension()) && "".equals(artifact.getClassifier()) && artifact.getPath() != null && Files.isRegularFile(artifactPath = artifact.getPath(), new LinkOption[0])) {
                try (JarFile artifactJar = new JarFile(artifactPath.toFile(), false);){
                    PluginsMetadata.PluginInfo pluginInfo;
                    block15: {
                        ZipEntry pluginDescriptorEntry = artifactJar.getEntry(PLUGIN_DESCRIPTOR_LOCATION);
                        if (pluginDescriptorEntry == null) break block14;
                        InputStream is = artifactJar.getInputStream(pluginDescriptorEntry);
                        try {
                            XmlNodeImpl root = XmlNodeBuilder.build((InputStream)is, null);
                            String groupId = root.getChild("groupId").getValue();
                            String artifactId = root.getChild("artifactId").getValue();
                            String goalPrefix = root.getChild("goalPrefix").getValue();
                            String name = root.getChild("name").getValue();
                            pluginInfo = new PluginsMetadata.PluginInfo(groupId, artifactId, goalPrefix, name);
                            if (is == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                    return pluginInfo;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

