// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.plugin.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.XmlNode;

/**
 * A set of goals to execute.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Execution
    implements Serializable
{
    /**
     * Configuration to pass to the goals.
     */
    final XmlNode configuration;
    /**
     * The goals to execute.
     */
    final List<String> goals;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Execution(
        XmlNode configuration,
        Collection<String> goals
    )
    {
        this.configuration = configuration;
        this.goals = ImmutableCollections.copy( goals );
    }

    /**
     * Configuration to pass to the goals.
     *
     * @return a {@code XmlNode}
     */
    public XmlNode getConfiguration()
    {
        return this.configuration;
    }

    /**
     * The goals to execute.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getGoals()
    {
        return this.goals;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Execution} instance using the specified configuration.
     *
     * @param configuration the new {@code XmlNode} to use
     * @return a {@code Execution} with the specified configuration
     */
    @Nonnull
    public Execution withConfiguration( XmlNode configuration )
    {
        return with().configuration( configuration ).build();
    }
    /**
     * Creates a new {@code Execution} instance using the specified goals.
     *
     * @param goals the new {@code Collection<String>} to use
     * @return a {@code Execution} with the specified goals
     */
    @Nonnull
    public Execution withGoals( Collection<String> goals )
    {
        return with().goals( goals ).build();
    }

    /**
     * Creates a new {@code Execution} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Execution}
     */
    @Nonnull
    public static Execution newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Execution} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Execution}
     */
    @Nonnull
    public static Execution newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Execution} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Execution} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Execution} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Execution} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Execution from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Execution} builder instance using the specified object as a basis.
     *
     * @param from the {@code Execution} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Execution from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Execution instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Execution base;
        XmlNode configuration;
        Collection<String> goals;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( Execution base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.configuration = base.configuration;
                this.goals = base.goals;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder configuration( XmlNode configuration )
        {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder goals( Collection<String> goals )
        {
            this.goals = goals;
            return this;
        }


        @Nonnull
        public Execution build()
        {
            if ( base != null
                    && ( configuration == null || configuration == base.configuration )
                    && ( goals == null || goals == base.goals )
            )
            {
                return base;
            }
            return new Execution(
                configuration != null ? configuration : ( base != null ? base.configuration : null ),
                goals != null ? goals : ( base != null ? base.goals : null )
            );
        }
    }

}
