// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.plugin.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * A custom lifecycle mapping definition.
 */
@Generated @ThreadSafe @Immutable
public class Lifecycle
    implements Serializable
{
    /**
     * The ID of this lifecycle, for identification in the mojo descriptor.
     */
    final String id;
    /**
     * The phase mappings for this lifecycle.
     */
    final List<Phase> phases;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Lifecycle(
        String id,
        Collection<Phase> phases
    )
    {
        this.id = id;
        this.phases = ImmutableCollections.copy( phases );
    }

    /**
     * The ID of this lifecycle, for identification in the mojo descriptor.
     */
    public String getId()
    {
        return this.id;
    }

    /**
     * The phase mappings for this lifecycle.
     */
    @Nonnull
    public List<Phase> getPhases()
    {
        return this.phases;
    }

    /**
     * Creates a new builder with this object as the basis.
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /** Creates a new Lifecycle instance using the specified id. */
    @Nonnull
    public Lifecycle withId( String id )
    {
        return with().id( id ).build();
    }
    /** Creates a new Lifecycle instance using the specified phases. */
    @Nonnull
    public Lifecycle withPhases( Collection<Phase> phases )
    {
        return with().phases( phases ).build();
    }

    /**
     * Creates a new Lifecycle instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     */
    @Nonnull
    public static Lifecycle newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new Lifecycle instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     */
    @Nonnull
    public static Lifecycle newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new Lifecycle builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new Lifecycle builder instance using default values or not.
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new Lifecycle builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     */
    @Nonnull
    public static Builder newBuilder( Lifecycle from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new Lifecycle builder instance using the specified object as a basis.
     */
    @Nonnull
    public static Builder newBuilder( Lifecycle from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Lifecycle instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Lifecycle base;
        String id;
        Collection<Phase> phases;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( Lifecycle base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.id = base.id;
                this.phases = base.phases;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder phases( Collection<Phase> phases )
        {
            this.phases = phases;
            return this;
        }


        @Nonnull
        public Lifecycle build()
        {
            if ( base != null
                    && ( id == null || id == base.id )
                    && ( phases == null || phases == base.phases )
            )
            {
                return base;
            }
            return new Lifecycle(
                id != null ? id : ( base != null ? base.id : null ),
                phases != null ? phases : ( base != null ? base.phases : null )
            );
        }
    }

}
