// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.plugin.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.Dom;

/**
 * A phase mapping definition.
 */
@Generated @ThreadSafe @Immutable
public class Phase
    implements Serializable
{
    /**
     * The ID of this phase, e.g., <code>generate-sources</code>.
     */
    final String id;
    /**
     * The goals to execute within the phase.
     */
    final List<Execution> executions;
    /**
     * Configuration to pass to all goals run in this phase.
     */
    final Dom configuration;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Phase(
        String id,
        Collection<Execution> executions,
        Dom configuration
    )
    {
        this.id = id;
        this.executions = ImmutableCollections.copy( executions );
        this.configuration = configuration;
    }

    /**
     * The ID of this phase, e.g., <code>generate-sources</code>.
     */
    public String getId()
    {
        return this.id;
    }

    /**
     * The goals to execute within the phase.
     */
    @Nonnull
    public List<Execution> getExecutions()
    {
        return this.executions;
    }

    /**
     * Configuration to pass to all goals run in this phase.
     */
    public Dom getConfiguration()
    {
        return this.configuration;
    }

    /**
     * Creates a new builder with this object as the basis.
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /** Creates a new Phase instance using the specified id. */
    @Nonnull
    public Phase withId( String id )
    {
        return with().id( id ).build();
    }
    /** Creates a new Phase instance using the specified executions. */
    @Nonnull
    public Phase withExecutions( Collection<Execution> executions )
    {
        return with().executions( executions ).build();
    }
    /** Creates a new Phase instance using the specified configuration. */
    @Nonnull
    public Phase withConfiguration( Dom configuration )
    {
        return with().configuration( configuration ).build();
    }

    /**
     * Creates a new Phase instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     */
    @Nonnull
    public static Phase newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new Phase instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     */
    @Nonnull
    public static Phase newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new Phase builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new Phase builder instance using default values or not.
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new Phase builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     */
    @Nonnull
    public static Builder newBuilder( Phase from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new Phase builder instance using the specified object as a basis.
     */
    @Nonnull
    public static Builder newBuilder( Phase from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Phase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Phase base;
        String id;
        Collection<Execution> executions;
        Dom configuration;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( Phase base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.id = base.id;
                this.executions = base.executions;
                this.configuration = base.configuration;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder executions( Collection<Execution> executions )
        {
            this.executions = executions;
            return this;
        }

        @Nonnull
        public Builder configuration( Dom configuration )
        {
            this.configuration = configuration;
            return this;
        }


        @Nonnull
        public Phase build()
        {
            if ( base != null
                    && ( id == null || id == base.id )
                    && ( executions == null || executions == base.executions )
                    && ( configuration == null || configuration == base.configuration )
            )
            {
                return base;
            }
            return new Phase(
                id != null ? id : ( base != null ? base.id : null ),
                executions != null ? executions : ( base != null ? base.executions : null ),
                configuration != null ? configuration : ( base != null ? base.configuration : null )
            );
        }
    }

}
