// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.plugin.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Root element of the <code>lifecycle.xml</code> file.
 */
@Generated @ThreadSafe @Immutable
public class LifecycleConfiguration
    implements Serializable
{
    final String modelEncoding;
    /**
     */
    final List<Lifecycle> lifecycles;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    LifecycleConfiguration(
        String modelEncoding,
        Collection<Lifecycle> lifecycles
    )
    {
        this.modelEncoding = modelEncoding;
        this.lifecycles = ImmutableCollections.copy( lifecycles );
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }

    /**
     */
    @Nonnull
    public List<Lifecycle> getLifecycles()
    {
        return this.lifecycles;
    }

    /**
     * Creates a new builder with this object as the basis.
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /** Creates a new LifecycleConfiguration instance using the specified lifecycles. */
    @Nonnull
    public LifecycleConfiguration withLifecycles( Collection<Lifecycle> lifecycles )
    {
        return with().lifecycles( lifecycles ).build();
    }

    /**
     * Creates a new LifecycleConfiguration instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     */
    @Nonnull
    public static LifecycleConfiguration newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new LifecycleConfiguration instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     */
    @Nonnull
    public static LifecycleConfiguration newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new LifecycleConfiguration builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new LifecycleConfiguration builder instance using default values or not.
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new LifecycleConfiguration builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     */
    @Nonnull
    public static Builder newBuilder( LifecycleConfiguration from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new LifecycleConfiguration builder instance using the specified object as a basis.
     */
    @Nonnull
    public static Builder newBuilder( LifecycleConfiguration from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create LifecycleConfiguration instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        LifecycleConfiguration base;
        String modelEncoding;
        Collection<Lifecycle> lifecycles;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( LifecycleConfiguration base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.lifecycles = base.lifecycles;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder modelEncoding( String modelEncoding )
        {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder lifecycles( Collection<Lifecycle> lifecycles )
        {
            this.lifecycles = lifecycles;
            return this;
        }


        @Nonnull
        public LifecycleConfiguration build()
        {
            if ( base != null
                    && ( lifecycles == null || lifecycles == base.lifecycles )
            )
            {
                return base;
            }
            return new LifecycleConfiguration(
                modelEncoding != null ? modelEncoding : ( base != null ? base.modelEncoding : "UTF-8" ),
                lifecycles != null ? lifecycles : ( base != null ? base.lifecycles : null )
            );
        }
    }

}
