package org.apache.maven.plugin.logging;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * @author jdcasey
 */
public interface Log
{
    boolean isDebugEnabled();
    
    void debug( CharSequence content );

    void debug( CharSequence content, Throwable error );

    void debug( Throwable error );

    boolean isInfoEnabled();
    
    void info( CharSequence content );

    void info( CharSequence content, Throwable error );

    void info( Throwable error );

    boolean isWarnEnabled();
    
    void warn( CharSequence content );

    void warn( CharSequence content, Throwable error );

    void warn( Throwable error );

    boolean isErrorEnabled();
    
    void error( CharSequence content );

    void error( CharSequence content, Throwable error );

    void error( Throwable error );
}