package org.apache.maven.plugin;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

import java.util.Map;

/**
 * @version $Id: AbstractMojo.java 292023 2005-09-27 19:49:37Z jdcasey $
 */
public abstract class AbstractMojo
    implements Mojo, ContextEnabled
{
    private Log log;
    private Map pluginContext;

    public void setLog( Log log )
    {
        this.log = log;
    }

    public Log getLog()
    {
        if ( log == null )
        {
            log = new SystemStreamLog();
        }

        return log;
    }

    public Map getPluginContext()
    {
        return pluginContext;
    }

    public void setPluginContext( Map pluginContext )
    {
        this.pluginContext = pluginContext;
    }
    
}
