/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.interpolation;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.interpolation.BuildTimestampValueSource;
import org.apache.maven.model.interpolation.ModelInterpolator;
import org.apache.maven.model.interpolation.PathTranslatingPostProcessor;
import org.apache.maven.model.interpolation.ProblemDetectingValueSource;
import org.apache.maven.model.interpolation.UrlNormalizingPostProcessor;
import org.apache.maven.model.path.PathTranslator;
import org.apache.maven.model.path.UrlNormalizer;
import org.apache.maven.model.root.RootLocator;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.RecursionInterceptor;
import org.codehaus.plexus.interpolation.ValueSource;

public abstract class AbstractStringBasedModelInterpolator
implements ModelInterpolator {
    private static final String PREFIX_PROJECT = "project.";
    private static final String PREFIX_POM = "pom.";
    private static final List<String> PROJECT_PREFIXES_3_1 = Arrays.asList("pom.", "project.");
    private static final List<String> PROJECT_PREFIXES_4_0 = Collections.singletonList("project.");
    private static final Collection<String> TRANSLATED_PATH_EXPRESSIONS;
    private final PathTranslator pathTranslator;
    private final UrlNormalizer urlNormalizer;
    private final RootLocator rootLocator;

    @Inject
    public AbstractStringBasedModelInterpolator(PathTranslator pathTranslator, UrlNormalizer urlNormalizer, RootLocator rootLocator) {
        this.pathTranslator = pathTranslator;
        this.urlNormalizer = urlNormalizer;
        this.rootLocator = rootLocator;
    }

    @Override
    public Model interpolateModel(Model model, File projectDir, ModelBuildingRequest request, ModelProblemCollector problems) {
        return new Model(this.interpolateModel(model.getDelegate(), projectDir, request, problems));
    }

    protected List<String> getProjectPrefixes(ModelBuildingRequest config) {
        return config.getValidationLevel() >= 40 ? PROJECT_PREFIXES_4_0 : PROJECT_PREFIXES_3_1;
    }

    protected List<ValueSource> createValueSources(org.apache.maven.api.model.Model model, final File projectDir, final ModelBuildingRequest config, ModelProblemCollector problems) {
        Object prefixlessObjectBasedValueSource;
        Object projectPrefixValueSource;
        Map modelProperties = model.getProperties();
        if (config.getValidationLevel() >= 40) {
            projectPrefixValueSource = new PrefixedObjectValueSource(PROJECT_PREFIXES_4_0, (Object)model, false);
            prefixlessObjectBasedValueSource = new ObjectBasedValueSource((Object)model);
        } else {
            projectPrefixValueSource = new PrefixedObjectValueSource(PROJECT_PREFIXES_3_1, (Object)model, false);
            if (config.getValidationLevel() >= 20) {
                projectPrefixValueSource = new ProblemDetectingValueSource((ValueSource)projectPrefixValueSource, PREFIX_POM, PREFIX_PROJECT, problems);
            }
            prefixlessObjectBasedValueSource = new ObjectBasedValueSource((Object)model);
            if (config.getValidationLevel() >= 20) {
                prefixlessObjectBasedValueSource = new ProblemDetectingValueSource((ValueSource)prefixlessObjectBasedValueSource, "", PREFIX_PROJECT, problems);
            }
        }
        ArrayList<ValueSource> valueSources = new ArrayList<ValueSource>(9);
        if (projectDir != null) {
            PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("basedir".equals(expression)) {
                        return projectDir.getAbsolutePath();
                    }
                    return null;
                }
            }, this.getProjectPrefixes(config), true);
            valueSources.add((ValueSource)basedirValueSource);
            PrefixedValueSourceWrapper baseUriValueSource = new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

                public Object getValue(String expression) {
                    if ("baseUri".equals(expression)) {
                        return projectDir.getAbsoluteFile().toPath().toUri().toASCIIString();
                    }
                    return null;
                }
            }, this.getProjectPrefixes(config), false);
            valueSources.add((ValueSource)baseUriValueSource);
            valueSources.add((ValueSource)new BuildTimestampValueSource(config.getBuildStartTime(), modelProperties));
        }
        valueSources.add((ValueSource)new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                if ("rootDirectory".equals(expression)) {
                    Path base = projectDir != null ? projectDir.toPath() : null;
                    Path root = AbstractStringBasedModelInterpolator.this.rootLocator.findMandatoryRoot(base);
                    return root.toFile().getPath();
                }
                return null;
            }
        }, this.getProjectPrefixes(config)));
        valueSources.add((ValueSource)projectPrefixValueSource);
        valueSources.add((ValueSource)new MapBasedValueSource((Map)config.getUserProperties()));
        valueSources.add((ValueSource)new MapBasedValueSource(modelProperties));
        valueSources.add((ValueSource)new MapBasedValueSource((Map)config.getSystemProperties()));
        valueSources.add((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                return config.getSystemProperties().getProperty("env." + expression);
            }
        });
        valueSources.add((ValueSource)prefixlessObjectBasedValueSource);
        return valueSources;
    }

    protected List<? extends InterpolationPostProcessor> createPostProcessors(org.apache.maven.api.model.Model model, File projectDir, ModelBuildingRequest config) {
        ArrayList<Object> processors = new ArrayList<Object>(2);
        if (projectDir != null) {
            processors.add(new PathTranslatingPostProcessor(this.getProjectPrefixes(config), TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator));
        }
        processors.add(new UrlNormalizingPostProcessor(this.urlNormalizer));
        return processors;
    }

    protected RecursionInterceptor createRecursionInterceptor(ModelBuildingRequest config) {
        return new PrefixAwareRecursionInterceptor(this.getProjectPrefixes(config));
    }

    static {
        HashSet<String> translatedPrefixes = new HashSet<String>();
        translatedPrefixes.add("build.directory");
        translatedPrefixes.add("build.outputDirectory");
        translatedPrefixes.add("build.testOutputDirectory");
        translatedPrefixes.add("build.sourceDirectory");
        translatedPrefixes.add("build.testSourceDirectory");
        translatedPrefixes.add("build.scriptSourceDirectory");
        translatedPrefixes.add("reporting.outputDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }
}

