/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.superpom;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.superpom.SuperPomProvider;

@Named
@Singleton
public class DefaultSuperPomProvider
implements SuperPomProvider {
    private final ModelProcessor modelProcessor;
    private static final Map<String, Model> SUPER_MODELS = new ConcurrentHashMap<String, Model>();

    @Inject
    public DefaultSuperPomProvider(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
    }

    @Override
    public Model getSuperModel(String version) {
        return SUPER_MODELS.computeIfAbsent(Objects.requireNonNull(version), v -> {
            String resource = "/org/apache/maven/model/pom-" + v + ".xml";
            InputStream is = this.getClass().getResourceAsStream(resource);
            if (is == null) {
                throw new IllegalStateException("The super POM " + resource + " was not found, please verify the integrity of your Maven installation");
            }
            try {
                HashMap<Object, CallSite> options = new HashMap<Object, CallSite>(2);
                options.put("xml:" + version, (CallSite)((Object)("xml:" + version)));
                String modelId = "org.apache.maven:maven-model-builder:" + version + "-" + this.getClass().getPackage().getImplementationVersion() + ":super-pom";
                org.apache.maven.api.model.InputSource inputSource = new org.apache.maven.api.model.InputSource(modelId, this.getClass().getResource(resource).toExternalForm());
                options.put("org.apache.maven.model.io.inputSource", (CallSite)new InputSource(inputSource));
                return this.modelProcessor.read(is, options);
            }
            catch (IOException e) {
                throw new IllegalStateException("The super POM " + resource + " is damaged, please verify the integrity of your Maven installation", e);
            }
        });
    }
}

