/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.profile.activation;

import java.util.Objects;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.ProfileActivator;

@Named(value="packaging")
@Singleton
public class PackagingProfileActivator
implements ProfileActivator {
    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        return PackagingProfileActivator.getActivationPackaging(profile).map(p -> PackagingProfileActivator.isPackaging(context, p)).orElse(false);
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        return PackagingProfileActivator.getActivationPackaging(profile).isPresent();
    }

    private static boolean isPackaging(ProfileActivationContext context, String p) {
        String packaging = context.getUserProperties().get("packaging");
        return Objects.equals(p, packaging);
    }

    private static Optional<String> getActivationPackaging(Profile profile) {
        return Optional.ofNullable(profile).map(Profile::getDelegate).map(org.apache.maven.api.model.Profile::getActivation).map(Activation::getPackaging);
    }
}

