/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.di.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.di.Provides;
import org.apache.maven.api.di.Qualifier;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.di.Typed;
import org.apache.maven.di.Injector;
import org.apache.maven.di.Key;
import org.apache.maven.di.Scope;
import org.apache.maven.di.impl.Binding;
import org.apache.maven.di.impl.DIException;
import org.apache.maven.di.impl.Dependency;
import org.apache.maven.di.impl.ReflectionUtils;
import org.apache.maven.di.impl.Types;

public class InjectorImpl
implements Injector {
    private final Map<Key<?>, Set<Binding<?>>> bindings = new HashMap();
    private final Map<Class<? extends Annotation>, Supplier<Scope>> scopes = new HashMap<Class<? extends Annotation>, Supplier<Scope>>();
    private final Set<String> loadedUrls = new HashSet<String>();
    private final LinkedHashSet<Key<?>> current = new LinkedHashSet();

    public InjectorImpl() {
        this.bindScope(Singleton.class, new SingletonScope());
    }

    @Override
    public <T> T getInstance(Class<T> key) {
        return this.getInstance(Key.of(key));
    }

    @Override
    public <T> T getInstance(Key<T> key) {
        return this.getCompiledBinding(new Dependency<T>(key, false)).get();
    }

    @Override
    public <T> void injectInstance(T instance) {
        ReflectionUtils.generateInjectingInitializer(Key.of(instance.getClass())).compile(this::getCompiledBinding).accept(instance);
    }

    @Override
    public Injector discover(ClassLoader classLoader) {
        try {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/maven/org.apache.maven.api.di.Inject");
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                if (!this.loadedUrls.add(url.toExternalForm())) continue;
                InputStream is = url.openStream();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(is)));){
                    for (String line : reader.lines().filter(l -> !l.startsWith("#")).toList()) {
                        Class<?> clazz = classLoader.loadClass(line);
                        this.bindImplicit(clazz);
                    }
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception e) {
            throw new DIException("Error while discovering DI classes from classLoader", e);
        }
        return this;
    }

    @Override
    public Injector bindScope(Class<? extends Annotation> scopeAnnotation, Scope scope) {
        return this.bindScope(scopeAnnotation, () -> scope);
    }

    @Override
    public Injector bindScope(Class<? extends Annotation> scopeAnnotation, Supplier<Scope> scope) {
        if (this.scopes.put(scopeAnnotation, scope) != null) {
            throw new DIException("Cannot rebind scope annotation class to a different implementation: " + scopeAnnotation);
        }
        return this;
    }

    public <U> Injector bindInstance(Class<U> clazz, U instance) {
        Key<U> key = Key.of(clazz, ReflectionUtils.qualifierOf(clazz));
        Binding<U> binding = Binding.toInstance(instance);
        return this.doBind(key, binding);
    }

    @Override
    public Injector bindImplicit(Class<?> clazz) {
        Key<?> key = Key.of(clazz, ReflectionUtils.qualifierOf(clazz));
        if (clazz.isInterface()) {
            this.bindings.computeIfAbsent(key, $ -> new HashSet());
            if (key.getQualifier() != null) {
                this.bindings.computeIfAbsent(Key.ofType(clazz), $ -> new HashSet());
            }
        } else if (!Modifier.isAbstract(clazz.getModifiers())) {
            Binding<?> binding = ReflectionUtils.generateImplicitBinding(key);
            this.doBind(key, binding);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Injector doBind(Key<?> key, Binding<?> binding) {
        if (!this.current.add(key)) {
            this.current.add(key);
            throw new DIException("Circular references: " + this.current);
        }
        try {
            this.doBindImplicit(key, binding);
            for (Class<?> cls = key.getRawType().getSuperclass(); cls != Object.class && cls != null; cls = cls.getSuperclass()) {
                this.doBindImplicit(Key.of(cls, key.getQualifier()), binding);
                if (key.getQualifier() == null) continue;
                this.bind(Key.ofType(cls), binding);
            }
            InjectorImpl injectorImpl = this;
            return injectorImpl;
        }
        finally {
            this.current.remove(key);
        }
    }

    protected <U> Injector bind(Key<U> key, Binding<U> b) {
        Set bindingSet = this.bindings.computeIfAbsent(key, $ -> new HashSet());
        bindingSet.add(b);
        return this;
    }

    protected <T> Set<Binding<T>> getBindings(Key<T> key) {
        return this.bindings.get(key);
    }

    protected Set<Key<?>> getBoundKeys() {
        return this.bindings.keySet();
    }

    public Map<Key<?>, Set<Binding<?>>> getBindings() {
        return this.bindings;
    }

    public <Q> Supplier<Q> getCompiledBinding(Dependency<Q> dep) {
        Set res2;
        Key<Q> key = dep.key();
        Set<Binding<Q>> res = this.getBindings(key);
        if (res != null && !res.isEmpty()) {
            ArrayList<Binding<Q>> bindingList = new ArrayList<Binding<Q>>(res);
            Comparator<Binding> comparing = Comparator.comparing(Binding::getPriority);
            bindingList.sort(comparing.reversed());
            Binding binding = (Binding)bindingList.get(0);
            return this.compile(binding);
        }
        if (key.getRawType() == List.class && (res2 = this.getBindings(key.getTypeParameter(0))) != null) {
            List list = res2.stream().map(this::compile).collect(Collectors.toList());
            return () -> this.list(list, Supplier::get);
        }
        if (key.getRawType() == Map.class) {
            Key k = key.getTypeParameter(0);
            Key v = key.getTypeParameter(1);
            Set res22 = this.getBindings(v);
            if (k.getRawType() == String.class && res22 != null) {
                Map<String, Supplier> map = res22.stream().filter(b -> b.getOriginalKey() == null || b.getOriginalKey().getQualifier() == null || b.getOriginalKey().getQualifier() instanceof String).collect(Collectors.toMap(b -> (String)(b.getOriginalKey() != null ? b.getOriginalKey().getQualifier() : null), this::compile));
                return () -> this.map(map, Supplier::get);
            }
        }
        if (dep.optional()) {
            return () -> null;
        }
        throw new DIException("No binding to construct an instance for key " + key.getDisplayString() + ".  Existing bindings:\n" + this.getBoundKeys().stream().map(Key::toString).map(String::trim).sorted().distinct().collect(Collectors.joining("\n - ", " - ", "")));
    }

    protected <Q> Supplier<Q> compile(Binding<Q> binding) {
        Supplier<Object> compiled = binding.compile(this::getCompiledBinding);
        if (binding.getScope() != null) {
            Scope scope = (Scope)this.scopes.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(binding.getScope())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new DIException("Scope not bound for annotation " + binding.getScope().annotationType())).get();
            compiled = scope.scope(binding.getOriginalKey(), compiled);
        }
        return compiled;
    }

    protected void doBindImplicit(Key<?> key, Binding<?> binding) {
        if (binding != null) {
            Object qualifier = key.getQualifier();
            Class<?> type = key.getRawType();
            Set<Class<?>> types = InjectorImpl.getBoundTypes(type.getAnnotation(Typed.class), type);
            for (Type t : Types.getAllSuperTypes(type)) {
                if (types != null && !types.contains(Types.getRawType(t))) continue;
                this.bind(Key.ofType(t, qualifier), binding);
                if (qualifier == null) continue;
                this.bind(Key.ofType(t), binding);
            }
        }
        for (Class<?> clazz : key.getRawType().getDeclaredClasses()) {
            boolean hasQualifier = Stream.of(clazz.getAnnotations()).anyMatch(ann -> ann.annotationType().isAnnotationPresent(Qualifier.class));
            if (!hasQualifier) continue;
            this.bindImplicit(clazz);
        }
        for (GenericDeclaration genericDeclaration : key.getRawType().getDeclaredMethods()) {
            if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(Provides.class)) continue;
            if (((Method)genericDeclaration).getTypeParameters().length != 0) {
                throw new DIException("Parameterized method are not supported " + (Method)genericDeclaration);
            }
            Object qualifier = ReflectionUtils.qualifierOf(genericDeclaration);
            Annotation scope = ReflectionUtils.scopeOf(genericDeclaration);
            Type returnType = ((Method)genericDeclaration).getGenericReturnType();
            Set<Class<?>> types = InjectorImpl.getBoundTypes(((Method)genericDeclaration).getAnnotation(Typed.class), Types.getRawType(returnType));
            Binding bind = ReflectionUtils.bindingFromMethod((Method)genericDeclaration).scope(scope);
            for (Type t : Types.getAllSuperTypes(returnType)) {
                if (types != null && !types.contains(Types.getRawType(t))) continue;
                this.bind(Key.ofType(t, qualifier), bind);
                if (qualifier == null) continue;
                this.bind(Key.ofType(t), bind);
            }
        }
    }

    private static Set<Class<?>> getBoundTypes(Typed typed, Class<?> clazz) {
        if (typed != null) {
            Class[] typesArray = typed.value();
            if (typesArray == null || typesArray.length == 0) {
                HashSet types = new HashSet(Arrays.asList(clazz.getInterfaces()));
                types.add(Object.class);
                return types;
            }
            return new HashSet(Arrays.asList(typesArray));
        }
        return null;
    }

    protected <K, V, T> Map<K, V> map(Map<K, T> map, Function<T, V> mapper) {
        return new WrappingMap<K, V, T>(map, mapper);
    }

    protected <Q, T> List<Q> list(List<T> bindingList, Function<T, Q> mapper) {
        return new WrappingList<Q, T>(bindingList, mapper);
    }

    private static class SingletonScope
    implements Scope {
        Map<Key<?>, Supplier<?>> cache = new ConcurrentHashMap();

        private SingletonScope() {
        }

        @Override
        public <T> Supplier<T> scope(Key<T> key, final Supplier<T> unscoped) {
            return this.cache.computeIfAbsent(key, k -> new Supplier<T>(){
                volatile T instance;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T get() {
                    if (this.instance == null) {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.instance == null) {
                                this.instance = unscoped.get();
                            }
                        }
                    }
                    return this.instance;
                }
            });
        }
    }

    private static class WrappingMap<K, V, T>
    extends AbstractMap<K, V> {
        private final Map<K, T> delegate;
        private final Function<T, V> mapper;

        WrappingMap(Map<K, T> delegate, Function<T, V> mapper) {
            this.delegate = delegate;
            this.mapper = mapper;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    final Iterator it = delegate.entrySet().iterator();
                    return new Iterator<Map.Entry<K, V>>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Map.Entry n = (Map.Entry)it.next();
                            return new AbstractMap.SimpleImmutableEntry(n.getKey(), mapper.apply(n.getValue()));
                        }
                    };
                }

                @Override
                public int size() {
                    return delegate.size();
                }
            };
        }
    }

    private static class WrappingList<Q, T>
    extends AbstractList<Q> {
        private final List<T> delegate;
        private final Function<T, Q> mapper;

        WrappingList(List<T> delegate, Function<T, Q> mapper) {
            this.delegate = delegate;
            this.mapper = mapper;
        }

        @Override
        public Q get(int index) {
            return this.mapper.apply(this.delegate.get(index));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }
}

