package org.apache.maven.artifact.ant;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.settings.Server;

/**
 * Ant Wrapper for wagon authentication.
 *
 * @author <a href="mailto:brett@apache.org">Brett Porter</a>
 * @version $Id: Authentication.java 189489 2005-06-08 01:49:48Z brett $
 */
public class Authentication
    extends AuthenticationInfo
{
    public Authentication()
    {
        super();
    }

    public Authentication( Server server )
    {
        setUserName( server.getUsername() );
        setPassword( server.getPassword() );
        setPassphrase( server.getPassphrase() );
        setPrivateKey( server.getPrivateKey() );
    }
}
