/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.tools.ant.BuildException;
import org.codehaus.plexus.PlexusContainerException;

public class InstallWagonProviderTask
extends AbstractArtifactTask {
    private String artifactId;
    private String version;
    private static final String WAGON_GROUP_ID = "org.apache.maven.wagon";

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void doExecute() throws BuildException {
        ArtifactResolutionResult result;
        VersionRange versionRange;
        MavenMetadataSource metadataSource = (MavenMetadataSource)this.lookup(ArtifactMetadataSource.ROLE);
        ArtifactResolver resolver = (ArtifactResolver)this.lookup(ArtifactResolver.ROLE);
        ArtifactRepository artifactRepository = this.createRemoteArtifactRepository(AbstractArtifactTask.getDefaultRemoteRepository());
        List<ArtifactRepository> remoteRepositories = Collections.singletonList(artifactRepository);
        try {
            versionRange = VersionRange.createFromVersionSpec((String)this.version);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new BuildException("Unable to get extension '" + ArtifactUtils.versionlessKey((String)WAGON_GROUP_ID, (String)this.artifactId) + "' because version '" + this.version + " is invalid: " + e.getMessage(), (Throwable)e);
        }
        ArtifactFactory factory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
        Artifact providerArtifact = factory.createExtensionArtifact(WAGON_GROUP_ID, this.artifactId, versionRange);
        try {
            result = resolver.resolveTransitively(Collections.singleton(providerArtifact), this.createArtifact(this.createDummyPom()), this.createLocalArtifactRepository(), remoteRepositories, (ArtifactMetadataSource)metadataSource, null);
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException("Error downloading wagon provider from the remote repository: " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new BuildException("Unable to locate wagon provider in remote repository: " + e.getMessage(), (Throwable)e);
        }
        this.log("Installing provider: " + providerArtifact);
        try {
            Iterator i = result.getArtifacts().iterator();
            while (i.hasNext()) {
                Artifact a = (Artifact)i.next();
                this.getEmbedder().getContainer().addJarResource(a.getFile());
            }
        }
        catch (PlexusContainerException e) {
            throw new BuildException("Unable to locate wagon provider in remote repository", (Throwable)e);
        }
    }
}

