/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.tools.ant.BuildException;

public class InstallTask
extends AbstractArtifactTask {
    private File file;

    protected void doExecute() {
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        MavenProjectBuilder builder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        Pom pom = this.buildPom(builder, localRepo);
        Artifact artifact = this.createArtifact(pom);
        boolean isPomArtifact = "pom".equals(pom.getPackaging());
        if (!isPomArtifact) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom.getFile());
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        ArtifactInstaller installer = (ArtifactInstaller)this.lookup(ArtifactInstaller.ROLE);
        try {
            if (!isPomArtifact) {
                installer.install(this.file, artifact, localRepo);
            } else {
                installer.install(pom.getFile(), artifact, localRepo);
            }
        }
        catch (ArtifactInstallationException e) {
            throw new BuildException("Error installing artifact '" + artifact.getDependencyConflictId() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

