/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.tools.ant.BuildException;

public class DeployTask
extends AbstractArtifactTask {
    private RemoteRepository remoteRepository;
    private RemoteRepository remoteSnapshotRepository;
    private File file;

    public void execute() {
        boolean isPomArtifact;
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        MavenProjectBuilder builder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        Pom pom = this.buildPom(builder, localRepo);
        if (pom == null) {
            throw new BuildException("A POM element is required to deploy to the repository");
        }
        if (this.remoteRepository == null) {
            if (pom.getDistributionManagement() == null || pom.getDistributionManagement().getRepository() == null) {
                throw new BuildException("A distributionManagement element is required in your POM to deploy");
            }
            this.remoteRepository = this.createAntRemoteRepositoryBase((RepositoryBase)pom.getDistributionManagement().getRepository());
        }
        if (this.remoteSnapshotRepository == null && pom.getDistributionManagement().getSnapshotRepository() != null) {
            this.remoteSnapshotRepository = this.createAntRemoteRepositoryBase((RepositoryBase)pom.getDistributionManagement().getSnapshotRepository());
        }
        Artifact artifact = this.createArtifact(pom);
        ArtifactRepository deploymentRepository = this.createRemoteArtifactRepository(this.remoteRepository);
        if (this.remoteSnapshotRepository != null && artifact.isSnapshot()) {
            deploymentRepository = this.createRemoteArtifactRepository(this.remoteSnapshotRepository);
        }
        if (!(isPomArtifact = "pom".equals(pom.getPackaging()))) {
            ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pom.getFile());
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        this.log("Deploying to " + deploymentRepository.getUrl());
        ArtifactDeployer deployer = (ArtifactDeployer)this.lookup(ArtifactDeployer.ROLE);
        try {
            if (!isPomArtifact) {
                deployer.deploy(this.file, artifact, deploymentRepository, localRepo);
            } else {
                deployer.deploy(pom.getFile(), artifact, deploymentRepository, localRepo);
            }
        }
        catch (ArtifactDeploymentException e) {
            throw new BuildException("Error deploying artifact", (Throwable)e);
        }
    }

    public RemoteRepository getRemoteRepository() {
        return this.remoteRepository;
    }

    public void addRemoteSnapshotRepository(RemoteRepository remoteSnapshotRepository) {
        this.remoteSnapshotRepository = remoteSnapshotRepository;
    }

    public void addRemoteRepository(RemoteRepository remoteRepository) {
        this.remoteRepository = remoteRepository;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

