/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactTask;
import org.apache.maven.artifact.ant.AntDownloadMonitor;
import org.apache.maven.artifact.ant.AntResolutionListener;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class DependenciesTask
extends AbstractArtifactTask {
    private List dependencies = new ArrayList();
    private List remoteRepositories = new ArrayList();
    private String pathId;
    private String filesetId;
    private boolean verbose;

    public void execute() {
        ArtifactResolutionResult result;
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        ArtifactResolver resolver = (ArtifactResolver)this.lookup(ArtifactResolver.ROLE);
        MavenProjectBuilder projectBuilder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        ArtifactFactory artifactFactory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
        MavenMetadataSource metadataSource = new MavenMetadataSource(resolver, projectBuilder, artifactFactory);
        List dependencies = this.dependencies;
        Pom pom = this.buildPom(projectBuilder, localRepo);
        if (pom != null) {
            if (!dependencies.isEmpty()) {
                throw new BuildException("You cannot specify both dependencies and a pom in the dependencies task");
            }
            dependencies = pom.getDependencies();
            Iterator i = pom.getRepositories().iterator();
            while (i.hasNext()) {
                Repository pomRepository = (Repository)i.next();
                this.remoteRepositories.add(this.createAntRemoteRepository(pomRepository));
            }
        } else {
            pom = this.createDummyPom();
        }
        Set artifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)artifactFactory, (List)dependencies, null, null);
        this.log("Resolving dependencies...");
        WagonManager wagonManager = (WagonManager)this.lookup(WagonManager.ROLE);
        wagonManager.setDownloadMonitor((TransferListener)new AntDownloadMonitor());
        try {
            Artifact pomArtifact = artifactFactory.createArtifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), null, pom.getPackaging());
            List<AntResolutionListener> listeners = Collections.EMPTY_LIST;
            if (this.verbose) {
                listeners = Collections.singletonList(new AntResolutionListener(this.getProject()));
            }
            List remoteArtifactRepositories = this.createRemoteArtifactRepositories(this.getRemoteRepositories());
            result = resolver.resolveTransitively(artifacts, pomArtifact, remoteArtifactRepositories, localRepo, (ArtifactMetadataSource)metadataSource, listeners);
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException("Unable to resolve artifact", (Throwable)e);
        }
        if (this.pathId != null && this.getProject().getReference(this.pathId) != null) {
            throw new BuildException("Reference ID " + this.pathId + " already exists");
        }
        if (this.filesetId != null && this.getProject().getReference(this.filesetId) != null) {
            throw new BuildException("Reference ID " + this.filesetId + " already exists");
        }
        FileList fileList = new FileList();
        fileList.setDir(this.getLocalRepository().getLocation());
        FileSet fileSet = new FileSet();
        fileSet.setDir(fileList.getDir(this.getProject()));
        Iterator i = result.getArtifacts().iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            String filename = localRepo.pathOf(artifact);
            FileList.FileName file = new FileList.FileName();
            file.setName(filename);
            fileList.addConfiguredFile(file);
            fileSet.createInclude().setName(filename);
        }
        if (this.pathId != null) {
            Path path = new Path(this.getProject());
            path.addFilelist(fileList);
            this.getProject().addReference(this.pathId, (Object)path);
        }
        if (this.filesetId != null) {
            this.getProject().addReference(this.filesetId, (Object)fileSet);
        }
    }

    private List createRemoteArtifactRepositories(List remoteRepositories) {
        ArrayList<ArtifactRepository> list = new ArrayList<ArtifactRepository>();
        Iterator i = remoteRepositories.iterator();
        while (i.hasNext()) {
            list.add(this.createRemoteArtifactRepository((RemoteRepository)((Object)i.next())));
        }
        return list;
    }

    public List getRemoteRepositories() {
        if (this.remoteRepositories.isEmpty()) {
            RemoteRepository remoteRepository = new RemoteRepository();
            remoteRepository.setUrl("http://repo1.maven.org/maven2");
            this.remoteRepositories.add(remoteRepository);
        }
        return this.remoteRepositories;
    }

    public void addRemoteRepository(RemoteRepository remoteRepository) {
        this.remoteRepositories.add(remoteRepository);
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public String getFilesetId() {
        return this.filesetId;
    }

    public void setFilesetId(String filesetId) {
        this.filesetId = filesetId;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

