/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.toolchain;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.toolchain.ImmutableCollections;
import org.apache.maven.api.toolchain.InputLocation;
import org.apache.maven.api.toolchain.InputLocationTracker;
import org.apache.maven.api.toolchain.TrackableBase;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ToolchainModel
extends TrackableBase
implements Serializable,
InputLocationTracker {
    final String type;
    final Map<String, String> provides;
    final XmlNode configuration;

    ToolchainModel(String type, Map<String, String> provides, XmlNode configuration, Map<Object, InputLocation> locations) {
        super(locations);
        this.type = type;
        this.provides = ImmutableCollections.copy(provides);
        this.configuration = configuration;
    }

    public String getType() {
        return this.type;
    }

    @Nonnull
    public Map<String, String> getProvides() {
        return this.provides;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nonnull
    public Builder with() {
        return ToolchainModel.newBuilder(this);
    }

    @Nonnull
    public ToolchainModel withType(String type) {
        return ToolchainModel.newBuilder(this, true).type(type).build();
    }

    @Nonnull
    public ToolchainModel withProvides(Map<String, String> provides) {
        return ToolchainModel.newBuilder(this, true).provides(provides).build();
    }

    @Nonnull
    public ToolchainModel withConfiguration(XmlNode configuration) {
        return ToolchainModel.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public static ToolchainModel newInstance() {
        return ToolchainModel.newInstance(true);
    }

    @Nonnull
    public static ToolchainModel newInstance(boolean withDefaults) {
        return ToolchainModel.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ToolchainModel.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ToolchainModel from) {
        return ToolchainModel.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ToolchainModel from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public int hashCode() {
        return Objects.hash(this.getType(), this.getProvides());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolchainModel)) {
            return false;
        }
        ToolchainModel that = (ToolchainModel)other;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getProvides(), that.getProvides());
    }

    @NotThreadSafe
    public static class Builder
    extends TrackableBase.Builder {
        ToolchainModel base;
        String type;
        Map<String, String> provides;
        XmlNode configuration;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(ToolchainModel base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.type = base.type;
                this.provides = base.provides;
                this.configuration = base.configuration;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder provides(Map<String, String> provides) {
            this.provides = provides;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public ToolchainModel build() {
            if (!(this.base == null || this.type != null && this.type != this.base.type || this.provides != null && this.provides != this.base.provides || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("type", newlocs.containsKey("type") ? (InputLocation)newlocs.get("type") : (InputLocation)oldlocs.get("type"));
            locations.put("provides", newlocs.containsKey("provides") ? (InputLocation)newlocs.get("provides") : (InputLocation)oldlocs.get("provides"));
            locations.put("configuration", newlocs.containsKey("configuration") ? (InputLocation)newlocs.get("configuration") : (InputLocation)oldlocs.get("configuration"));
            return new ToolchainModel(this.type != null ? this.type : (this.base != null ? this.base.type : null), this.provides != null ? this.provides : (this.base != null ? this.base.provides : null), (XmlNode)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), locations);
        }
    }
}

