// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Common base class that contains code to track the source for this instance.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class TrackableBase
    implements Serializable, InputLocationTracker
{
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected TrackableBase(Builder builder) {
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * Gets the location of the specified field in the input source.
     *
     * @param key the key of the field, must not be {@code null}
     * @return the location of the field in the input source or {@code null} if unknown
     * @throws NullPointerException if {@code key} is {@code null}
     */
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }

    /**
     * Creates a new {@code TrackableBase} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code TrackableBase}
     */
    @Nonnull
    public static TrackableBase newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code TrackableBase} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code TrackableBase}
     */
    @Nonnull
    public static TrackableBase newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code TrackableBase} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code TrackableBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code TrackableBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code TrackableBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(TrackableBase from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code TrackableBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code TrackableBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(TrackableBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create TrackableBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        TrackableBase base;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(TrackableBase base, boolean forceCopy) {
            if (forceCopy) {
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public TrackableBase build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
            ) {
                return base;
            }
            return new TrackableBase(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }

}
