/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.ActivationFile;
import org.apache.maven.api.settings.ActivationOS;
import org.apache.maven.api.settings.ActivationProperty;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Activation
implements Serializable {
    final boolean activeByDefault;
    final String jdk;
    final ActivationOS os;
    final ActivationProperty property;
    final ActivationFile file;

    Activation(boolean activeByDefault, String jdk, ActivationOS os, ActivationProperty property, ActivationFile file) {
        this.activeByDefault = activeByDefault;
        this.jdk = jdk;
        this.os = os;
        this.property = property;
        this.file = file;
    }

    public boolean isActiveByDefault() {
        return this.activeByDefault;
    }

    public String getJdk() {
        return this.jdk;
    }

    public ActivationOS getOs() {
        return this.os;
    }

    public ActivationProperty getProperty() {
        return this.property;
    }

    public ActivationFile getFile() {
        return this.file;
    }

    @Nonnull
    public Builder with() {
        return Activation.newBuilder(this);
    }

    @Nonnull
    public Activation withActiveByDefault(boolean activeByDefault) {
        return Activation.newBuilder(this, true).activeByDefault(activeByDefault).build();
    }

    @Nonnull
    public Activation withJdk(String jdk) {
        return Activation.newBuilder(this, true).jdk(jdk).build();
    }

    @Nonnull
    public Activation withOs(ActivationOS os) {
        return Activation.newBuilder(this, true).os(os).build();
    }

    @Nonnull
    public Activation withProperty(ActivationProperty property) {
        return Activation.newBuilder(this, true).property(property).build();
    }

    @Nonnull
    public Activation withFile(ActivationFile file) {
        return Activation.newBuilder(this, true).file(file).build();
    }

    @Nonnull
    public static Activation newInstance() {
        return Activation.newInstance(true);
    }

    @Nonnull
    public static Activation newInstance(boolean withDefaults) {
        return Activation.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Activation.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Activation from) {
        return Activation.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Activation from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Activation base;
        Boolean activeByDefault;
        String jdk;
        ActivationOS os;
        ActivationProperty property;
        ActivationFile file;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.activeByDefault = false;
            }
        }

        Builder(Activation base, boolean forceCopy) {
            if (forceCopy) {
                this.activeByDefault = base.activeByDefault;
                this.jdk = base.jdk;
                this.os = base.os;
                this.property = base.property;
                this.file = base.file;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder activeByDefault(boolean activeByDefault) {
            this.activeByDefault = activeByDefault;
            return this;
        }

        @Nonnull
        public Builder jdk(String jdk) {
            this.jdk = jdk;
            return this;
        }

        @Nonnull
        public Builder os(ActivationOS os) {
            this.os = os;
            return this;
        }

        @Nonnull
        public Builder property(ActivationProperty property) {
            this.property = property;
            return this;
        }

        @Nonnull
        public Builder file(ActivationFile file) {
            this.file = file;
            return this;
        }

        @Nonnull
        public Activation build() {
            if (!(this.base == null || this.activeByDefault != null && this.activeByDefault != this.base.activeByDefault || this.jdk != null && this.jdk != this.base.jdk || this.os != null && this.os != this.base.os || this.property != null && this.property != this.base.property || this.file != null && this.file != this.base.file)) {
                return this.base;
            }
            return new Activation(this.activeByDefault != null ? this.activeByDefault : (this.base != null ? this.base.activeByDefault : false), this.jdk != null ? this.jdk : (this.base != null ? this.base.jdk : null), this.os != null ? this.os : (this.base != null ? this.base.os : null), this.property != null ? this.property : (this.base != null ? this.base.property : null), this.file != null ? this.file : (this.base != null ? this.base.file : null));
        }
    }
}

