// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.plugin.descriptor.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.XmlNode;

/**
 * A phase mapping definition.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Phase
    implements Serializable
{
    /**
     * The ID of this phase, e.g., {@code generate-sources}.
     */
    final String id;
    /**
     * If specified, identifies this phase as a dynamic phase to decorate the specified phase id, e.g. {@code after} or {@code before}.
     */
    final String executionPoint;
    /**
     * If specified, identifies a within phase prioritization of executions.
     */
    final int priority;
    /**
     * The goals to execute within the phase.
     */
    final List<Execution> executions;
    /**
     * Configuration to pass to all goals run in this phase.
     */
    final XmlNode configuration;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Phase(Builder builder) {
        this.id = builder.id != null ? builder.id : (builder.base != null ? builder.base.id : null);
        this.executionPoint = builder.executionPoint != null ? builder.executionPoint : (builder.base != null ? builder.base.executionPoint : null);
        this.priority = builder.priority != null ? builder.priority : (builder.base != null ? builder.base.priority : 0);
        this.executions = ImmutableCollections.copy(builder.executions != null ? builder.executions : (builder.base != null ? builder.base.executions : null));
        this.configuration = builder.configuration != null ? builder.configuration : (builder.base != null ? builder.base.configuration : null);
    }

    /**
     * The ID of this phase, e.g., {@code generate-sources}.
     *
     * @return a {@code String}
     */
    public String getId() {
        return this.id;
    }

    /**
     * If specified, identifies this phase as a dynamic phase to decorate the specified phase id, e.g. {@code after} or {@code before}.
     *
     * @return a {@code String}
     */
    public String getExecutionPoint() {
        return this.executionPoint;
    }

    /**
     * If specified, identifies a within phase prioritization of executions.
     *
     * @return a {@code int}
     */
    public int getPriority() {
        return this.priority;
    }

    /**
     * The goals to execute within the phase.
     *
     * @return a {@code List<Execution>}
     */
    @Nonnull
    public List<Execution> getExecutions() {
        return this.executions;
    }

    /**
     * Configuration to pass to all goals run in this phase.
     *
     * @return a {@code XmlNode}
     */
    public XmlNode getConfiguration() {
        return this.configuration;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Phase} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Phase} with the specified id
     */
    @Nonnull
    public Phase withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code Phase} instance using the specified executionPoint.
     *
     * @param executionPoint the new {@code String} to use
     * @return a {@code Phase} with the specified executionPoint
     */
    @Nonnull
    public Phase withExecutionPoint(String executionPoint) {
        return newBuilder(this, true).executionPoint(executionPoint).build();
    }
    /**
     * Creates a new {@code Phase} instance using the specified priority.
     *
     * @param priority the new {@code int} to use
     * @return a {@code Phase} with the specified priority
     */
    @Nonnull
    public Phase withPriority(int priority) {
        return newBuilder(this, true).priority(priority).build();
    }
    /**
     * Creates a new {@code Phase} instance using the specified executions.
     *
     * @param executions the new {@code Collection<Execution>} to use
     * @return a {@code Phase} with the specified executions
     */
    @Nonnull
    public Phase withExecutions(Collection<Execution> executions) {
        return newBuilder(this, true).executions(executions).build();
    }
    /**
     * Creates a new {@code Phase} instance using the specified configuration.
     *
     * @param configuration the new {@code XmlNode} to use
     * @return a {@code Phase} with the specified configuration
     */
    @Nonnull
    public Phase withConfiguration(XmlNode configuration) {
        return newBuilder(this, true).configuration(configuration).build();
    }

    /**
     * Creates a new {@code Phase} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Phase}
     */
    @Nonnull
    public static Phase newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Phase} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Phase}
     */
    @Nonnull
    public static Phase newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Phase} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Phase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Phase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Phase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Phase from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Phase} builder instance using the specified object as a basis.
     *
     * @param from the {@code Phase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Phase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Phase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Phase base;
        String id;
        String executionPoint;
        Integer priority;
        Collection<Execution> executions;
        XmlNode configuration;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.priority = 0;
            }
        }

        protected Builder(Phase base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.executionPoint = base.executionPoint;
                this.priority = base.priority;
                this.executions = base.executions;
                this.configuration = base.configuration;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder executionPoint(String executionPoint) {
            this.executionPoint = executionPoint;
            return this;
        }

        @Nonnull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Nonnull
        public Builder executions(Collection<Execution> executions) {
            this.executions = executions;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }


        @Nonnull
        public Phase build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (id == null || id == base.id)
                    && (executionPoint == null || executionPoint == base.executionPoint)
                    && (priority == null || priority == base.priority)
                    && (executions == null || executions == base.executions)
                    && (configuration == null || configuration == base.configuration)
            ) {
                return base;
            }
            return new Phase(this);
        }
    }


    /**
     * Get the effective ID of this phase, e.g.,
     * {@code generate-sources} or {@code after:integration-test[1000]}.
     *
     * @return String
     */
    public String getEffectiveId() {
        if (executionPoint == null) {
            if (priority == 0) {
                return id;
            }
            return id + '[' + priority + ']';
        }
        if (priority == 0) {
            return executionPoint + ':' + id;
        }
        return executionPoint + ':' + id + '[' + priority + ']';
    }

}
