// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.plugin.descriptor.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * A custom lifecycle mapping definition.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Lifecycle
    implements Serializable
{
    /**
     * The ID of this lifecycle, for identification in the mojo descriptor.
     */
    final String id;
    /**
     * The phase mappings for this lifecycle.
     */
    final List<Phase> phases;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Lifecycle(Builder builder) {
        this.id = builder.id != null ? builder.id : (builder.base != null ? builder.base.id : null);
        this.phases = ImmutableCollections.copy(builder.phases != null ? builder.phases : (builder.base != null ? builder.base.phases : null));
    }

    /**
     * The ID of this lifecycle, for identification in the mojo descriptor.
     *
     * @return a {@code String}
     */
    public String getId() {
        return this.id;
    }

    /**
     * The phase mappings for this lifecycle.
     *
     * @return a {@code List<Phase>}
     */
    @Nonnull
    public List<Phase> getPhases() {
        return this.phases;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Lifecycle} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Lifecycle} with the specified id
     */
    @Nonnull
    public Lifecycle withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code Lifecycle} instance using the specified phases.
     *
     * @param phases the new {@code Collection<Phase>} to use
     * @return a {@code Lifecycle} with the specified phases
     */
    @Nonnull
    public Lifecycle withPhases(Collection<Phase> phases) {
        return newBuilder(this, true).phases(phases).build();
    }

    /**
     * Creates a new {@code Lifecycle} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Lifecycle}
     */
    @Nonnull
    public static Lifecycle newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Lifecycle} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Lifecycle}
     */
    @Nonnull
    public static Lifecycle newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Lifecycle} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Lifecycle} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Lifecycle} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Lifecycle} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Lifecycle from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Lifecycle} builder instance using the specified object as a basis.
     *
     * @param from the {@code Lifecycle} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Lifecycle from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Lifecycle instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Lifecycle base;
        String id;
        Collection<Phase> phases;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(Lifecycle base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.phases = base.phases;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder phases(Collection<Phase> phases) {
            this.phases = phases;
            return this;
        }


        @Nonnull
        public Lifecycle build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (id == null || id == base.id)
                    && (phases == null || phases == base.phases)
            ) {
                return base;
            }
            return new Lifecycle(this);
        }
    }

}
