// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * A Mojo description.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class MojoDescriptor
    implements Serializable
{
    /**
     * The goal name for the Mojo, that users will reference from the command line to execute the Mojo directly,
     * or inside a POM in order to provide Mojo-specific configuration.
     */
    final String goal;
    /**
     * The description of this Mojo's functionality.
     */
    final String description;
    /**
     * The Mojo's fully-qualified class name (or script path in the case of non-Java Mojos).
     */
    final String implementation;
    /**
     * The implementation language for this Mojo (java, beanshell, etc.).
     */
    final String language;
    /**
     * Defines a default phase to bind a Mojo execution to if the user does not explicitly set a phase in the POM.
     * <p><b>Note:</b> This will not automagically make a Mojo run when the plugin declaration is added
     * to the POM. It merely enables the user to omit the {@code <phase>} element from the
     * surrounding {@code <execution>} element.</p>
     */
    final String phase;
    /**
     * Reference the invocation phase of the Mojo.
     */
    final String executePhase;
    /**
     * Reference the invocation goal of the Mojo.
     */
    final String executeGoal;
    /**
     * 
     */
    final String executeLifecycle;
    /**
     * Flags this Mojo as requiring the dependencies in the specified class path to be resolved before it can
     * execute: {@code compile}, {@code runtime}, {@code test},
     * {@code compile+runtime} (since Maven 3.0) or {@code runtime+system} (since Maven 3.0)
     */
    final String dependencyResolution;
    /**
     * Flags this Mojo as requiring information about the dependencies that would make up the specified class
     * path. As the name suggests, this is similar to requiresDependencyResolution and supports the same values.
     * The important difference is this will not resolve the files for the dependencies, i.e. the artifacts
     * associated with a Maven project can lack a file. As such, this annotation is meant for Mojos that only
     * want to analyze the set of transitive dependencies, in particular during early lifecycle phases where
     * full dependency resolution might fail due to projects which haven't been built yet.
     */
    final String dependencyCollection;
    /**
     * Flags this Mojo to be invoked directly only.
     */
    final boolean directInvocationOnly;
    /**
     * Flags this Mojo to require running inside of a project.
     */
    final boolean projectRequired;
    /**
     * Flags this Mojo to require online mode for its operation.
     */
    final boolean onlineRequired;
    /**
     * Flags this Mojo to run it in a multi-module way, i.e. aggregate the build with the set of projects
     * listed as modules.
     */
    final boolean aggregator;
    /**
     * Specify that the Mojo is inherited.
     */
    final boolean inheritedByDefault;
    /**
     * Specify the version when the Mojo was added to the API. Similar to Javadoc since.
     */
    final String since;
    /**
     * Description with the reason of Mojo deprecation. Similar to Javadoc {@code @deprecated}
     * This will trigger a warning when a user tries to use a Mojo marked as deprecated.
     */
    final String deprecated;
    /**
     * The configurator type to use when injecting parameter values into this Mojo. The value is normally deduced
     * from the Mojo's implementation language, but can be specified to allow a custom ComponentConfigurator
     * implementation to be used.
     */
    final String configurator;
    /**
     * 
     */
    final List<Parameter> parameters;
    /**
     * the id of the mojo, based on the goal name
     */
    final String id;
    /**
     * the full goal name
     */
    final String fullGoalName;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    MojoDescriptor(
        String goal,
        String description,
        String implementation,
        String language,
        String phase,
        String executePhase,
        String executeGoal,
        String executeLifecycle,
        String dependencyResolution,
        String dependencyCollection,
        boolean directInvocationOnly,
        boolean projectRequired,
        boolean onlineRequired,
        boolean aggregator,
        boolean inheritedByDefault,
        String since,
        String deprecated,
        String configurator,
        Collection<Parameter> parameters,
        String id,
        String fullGoalName
    ) {
        this.goal = goal;
        this.description = description;
        this.implementation = implementation;
        this.language = language;
        this.phase = phase;
        this.executePhase = executePhase;
        this.executeGoal = executeGoal;
        this.executeLifecycle = executeLifecycle;
        this.dependencyResolution = dependencyResolution;
        this.dependencyCollection = dependencyCollection;
        this.directInvocationOnly = directInvocationOnly;
        this.projectRequired = projectRequired;
        this.onlineRequired = onlineRequired;
        this.aggregator = aggregator;
        this.inheritedByDefault = inheritedByDefault;
        this.since = since;
        this.deprecated = deprecated;
        this.configurator = configurator;
        this.parameters = ImmutableCollections.copy(parameters);
        this.id = id;
        this.fullGoalName = fullGoalName;
    }

    /**
     * The goal name for the Mojo, that users will reference from the command line to execute the Mojo directly,
     * or inside a POM in order to provide Mojo-specific configuration.
     *
     * @return a {@code String}
     */
    public String getGoal() {
        return this.goal;
    }

    /**
     * The description of this Mojo's functionality.
     *
     * @return a {@code String}
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * The Mojo's fully-qualified class name (or script path in the case of non-Java Mojos).
     *
     * @return a {@code String}
     */
    public String getImplementation() {
        return this.implementation;
    }

    /**
     * The implementation language for this Mojo (java, beanshell, etc.).
     *
     * @return a {@code String}
     */
    public String getLanguage() {
        return this.language;
    }

    /**
     * Defines a default phase to bind a Mojo execution to if the user does not explicitly set a phase in the POM.
     * <p><b>Note:</b> This will not automagically make a Mojo run when the plugin declaration is added
     * to the POM. It merely enables the user to omit the {@code <phase>} element from the
     * surrounding {@code <execution>} element.</p>
     *
     * @return a {@code String}
     */
    public String getPhase() {
        return this.phase;
    }

    /**
     * Reference the invocation phase of the Mojo.
     *
     * @return a {@code String}
     */
    public String getExecutePhase() {
        return this.executePhase;
    }

    /**
     * Reference the invocation goal of the Mojo.
     *
     * @return a {@code String}
     */
    public String getExecuteGoal() {
        return this.executeGoal;
    }

    /**
     * 
     *
     * @return a {@code String}
     */
    public String getExecuteLifecycle() {
        return this.executeLifecycle;
    }

    /**
     * Flags this Mojo as requiring the dependencies in the specified class path to be resolved before it can
     * execute: {@code compile}, {@code runtime}, {@code test},
     * {@code compile+runtime} (since Maven 3.0) or {@code runtime+system} (since Maven 3.0)
     *
     * @return a {@code String}
     */
    public String getDependencyResolution() {
        return this.dependencyResolution;
    }

    /**
     * Flags this Mojo as requiring information about the dependencies that would make up the specified class
     * path. As the name suggests, this is similar to requiresDependencyResolution and supports the same values.
     * The important difference is this will not resolve the files for the dependencies, i.e. the artifacts
     * associated with a Maven project can lack a file. As such, this annotation is meant for Mojos that only
     * want to analyze the set of transitive dependencies, in particular during early lifecycle phases where
     * full dependency resolution might fail due to projects which haven't been built yet.
     *
     * @return a {@code String}
     */
    public String getDependencyCollection() {
        return this.dependencyCollection;
    }

    /**
     * Flags this Mojo to be invoked directly only.
     *
     * @return a {@code boolean}
     */
    public boolean isDirectInvocationOnly() {
        return this.directInvocationOnly;
    }

    /**
     * Flags this Mojo to require running inside of a project.
     *
     * @return a {@code boolean}
     */
    public boolean isProjectRequired() {
        return this.projectRequired;
    }

    /**
     * Flags this Mojo to require online mode for its operation.
     *
     * @return a {@code boolean}
     */
    public boolean isOnlineRequired() {
        return this.onlineRequired;
    }

    /**
     * Flags this Mojo to run it in a multi-module way, i.e. aggregate the build with the set of projects
     * listed as modules.
     *
     * @return a {@code boolean}
     */
    public boolean isAggregator() {
        return this.aggregator;
    }

    /**
     * Specify that the Mojo is inherited.
     *
     * @return a {@code boolean}
     */
    public boolean isInheritedByDefault() {
        return this.inheritedByDefault;
    }

    /**
     * Specify the version when the Mojo was added to the API. Similar to Javadoc since.
     *
     * @return a {@code String}
     */
    public String getSince() {
        return this.since;
    }

    /**
     * Description with the reason of Mojo deprecation. Similar to Javadoc {@code @deprecated}
     * This will trigger a warning when a user tries to use a Mojo marked as deprecated.
     *
     * @return a {@code String}
     */
    public String getDeprecated() {
        return this.deprecated;
    }

    /**
     * The configurator type to use when injecting parameter values into this Mojo. The value is normally deduced
     * from the Mojo's implementation language, but can be specified to allow a custom ComponentConfigurator
     * implementation to be used.
     *
     * @return a {@code String}
     */
    public String getConfigurator() {
        return this.configurator;
    }

    /**
     * 
     *
     * @return a {@code List<Parameter>}
     */
    @Nonnull
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    /**
     * the id of the mojo, based on the goal name
     *
     * @return a {@code String}
     */
    public String getId() {
        return this.id;
    }

    /**
     * the full goal name
     *
     * @return a {@code String}
     */
    public String getFullGoalName() {
        return this.fullGoalName;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified goal.
     *
     * @param goal the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified goal
     */
    @Nonnull
    public MojoDescriptor withGoal(String goal) {
        return newBuilder(this, true).goal(goal).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified description.
     *
     * @param description the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified description
     */
    @Nonnull
    public MojoDescriptor withDescription(String description) {
        return newBuilder(this, true).description(description).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified implementation.
     *
     * @param implementation the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified implementation
     */
    @Nonnull
    public MojoDescriptor withImplementation(String implementation) {
        return newBuilder(this, true).implementation(implementation).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified language.
     *
     * @param language the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified language
     */
    @Nonnull
    public MojoDescriptor withLanguage(String language) {
        return newBuilder(this, true).language(language).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified phase.
     *
     * @param phase the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified phase
     */
    @Nonnull
    public MojoDescriptor withPhase(String phase) {
        return newBuilder(this, true).phase(phase).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified executePhase.
     *
     * @param executePhase the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified executePhase
     */
    @Nonnull
    public MojoDescriptor withExecutePhase(String executePhase) {
        return newBuilder(this, true).executePhase(executePhase).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified executeGoal.
     *
     * @param executeGoal the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified executeGoal
     */
    @Nonnull
    public MojoDescriptor withExecuteGoal(String executeGoal) {
        return newBuilder(this, true).executeGoal(executeGoal).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified executeLifecycle.
     *
     * @param executeLifecycle the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified executeLifecycle
     */
    @Nonnull
    public MojoDescriptor withExecuteLifecycle(String executeLifecycle) {
        return newBuilder(this, true).executeLifecycle(executeLifecycle).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified dependencyResolution.
     *
     * @param dependencyResolution the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified dependencyResolution
     */
    @Nonnull
    public MojoDescriptor withDependencyResolution(String dependencyResolution) {
        return newBuilder(this, true).dependencyResolution(dependencyResolution).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified dependencyCollection.
     *
     * @param dependencyCollection the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified dependencyCollection
     */
    @Nonnull
    public MojoDescriptor withDependencyCollection(String dependencyCollection) {
        return newBuilder(this, true).dependencyCollection(dependencyCollection).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified directInvocationOnly.
     *
     * @param directInvocationOnly the new {@code boolean} to use
     * @return a {@code MojoDescriptor} with the specified directInvocationOnly
     */
    @Nonnull
    public MojoDescriptor withDirectInvocationOnly(boolean directInvocationOnly) {
        return newBuilder(this, true).directInvocationOnly(directInvocationOnly).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified projectRequired.
     *
     * @param projectRequired the new {@code boolean} to use
     * @return a {@code MojoDescriptor} with the specified projectRequired
     */
    @Nonnull
    public MojoDescriptor withProjectRequired(boolean projectRequired) {
        return newBuilder(this, true).projectRequired(projectRequired).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified onlineRequired.
     *
     * @param onlineRequired the new {@code boolean} to use
     * @return a {@code MojoDescriptor} with the specified onlineRequired
     */
    @Nonnull
    public MojoDescriptor withOnlineRequired(boolean onlineRequired) {
        return newBuilder(this, true).onlineRequired(onlineRequired).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified aggregator.
     *
     * @param aggregator the new {@code boolean} to use
     * @return a {@code MojoDescriptor} with the specified aggregator
     */
    @Nonnull
    public MojoDescriptor withAggregator(boolean aggregator) {
        return newBuilder(this, true).aggregator(aggregator).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified inheritedByDefault.
     *
     * @param inheritedByDefault the new {@code boolean} to use
     * @return a {@code MojoDescriptor} with the specified inheritedByDefault
     */
    @Nonnull
    public MojoDescriptor withInheritedByDefault(boolean inheritedByDefault) {
        return newBuilder(this, true).inheritedByDefault(inheritedByDefault).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified since.
     *
     * @param since the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified since
     */
    @Nonnull
    public MojoDescriptor withSince(String since) {
        return newBuilder(this, true).since(since).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified deprecated.
     *
     * @param deprecated the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified deprecated
     */
    @Nonnull
    public MojoDescriptor withDeprecated(String deprecated) {
        return newBuilder(this, true).deprecated(deprecated).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified configurator.
     *
     * @param configurator the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified configurator
     */
    @Nonnull
    public MojoDescriptor withConfigurator(String configurator) {
        return newBuilder(this, true).configurator(configurator).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified parameters.
     *
     * @param parameters the new {@code Collection<Parameter>} to use
     * @return a {@code MojoDescriptor} with the specified parameters
     */
    @Nonnull
    public MojoDescriptor withParameters(Collection<Parameter> parameters) {
        return newBuilder(this, true).parameters(parameters).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified id
     */
    @Nonnull
    public MojoDescriptor withId(String id) {
        return newBuilder(this, true).id(id).build();
    }
    /**
     * Creates a new {@code MojoDescriptor} instance using the specified fullGoalName.
     *
     * @param fullGoalName the new {@code String} to use
     * @return a {@code MojoDescriptor} with the specified fullGoalName
     */
    @Nonnull
    public MojoDescriptor withFullGoalName(String fullGoalName) {
        return newBuilder(this, true).fullGoalName(fullGoalName).build();
    }

    /**
     * Creates a new {@code MojoDescriptor} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code MojoDescriptor}
     */
    @Nonnull
    public static MojoDescriptor newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code MojoDescriptor} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code MojoDescriptor}
     */
    @Nonnull
    public static MojoDescriptor newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code MojoDescriptor} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code MojoDescriptor} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code MojoDescriptor} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code MojoDescriptor} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(MojoDescriptor from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code MojoDescriptor} builder instance using the specified object as a basis.
     *
     * @param from the {@code MojoDescriptor} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(MojoDescriptor from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create MojoDescriptor instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        MojoDescriptor base;
        String goal;
        String description;
        String implementation;
        String language;
        String phase;
        String executePhase;
        String executeGoal;
        String executeLifecycle;
        String dependencyResolution;
        String dependencyCollection;
        Boolean directInvocationOnly;
        Boolean projectRequired;
        Boolean onlineRequired;
        Boolean aggregator;
        Boolean inheritedByDefault;
        String since;
        String deprecated;
        String configurator;
        Collection<Parameter> parameters;
        String id;
        String fullGoalName;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.language = "java";
                this.dependencyResolution = "runtime";
                this.directInvocationOnly = false;
                this.projectRequired = true;
                this.onlineRequired = false;
                this.aggregator = false;
                this.inheritedByDefault = true;
            }
        }

        Builder(MojoDescriptor base, boolean forceCopy) {
            if (forceCopy) {
                this.goal = base.goal;
                this.description = base.description;
                this.implementation = base.implementation;
                this.language = base.language;
                this.phase = base.phase;
                this.executePhase = base.executePhase;
                this.executeGoal = base.executeGoal;
                this.executeLifecycle = base.executeLifecycle;
                this.dependencyResolution = base.dependencyResolution;
                this.dependencyCollection = base.dependencyCollection;
                this.directInvocationOnly = base.directInvocationOnly;
                this.projectRequired = base.projectRequired;
                this.onlineRequired = base.onlineRequired;
                this.aggregator = base.aggregator;
                this.inheritedByDefault = base.inheritedByDefault;
                this.since = base.since;
                this.deprecated = base.deprecated;
                this.configurator = base.configurator;
                this.parameters = base.parameters;
                this.id = base.id;
                this.fullGoalName = base.fullGoalName;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder goal(String goal) {
            this.goal = goal;
            return this;
        }

        @Nonnull
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder implementation(String implementation) {
            this.implementation = implementation;
            return this;
        }

        @Nonnull
        public Builder language(String language) {
            this.language = language;
            return this;
        }

        @Nonnull
        public Builder phase(String phase) {
            this.phase = phase;
            return this;
        }

        @Nonnull
        public Builder executePhase(String executePhase) {
            this.executePhase = executePhase;
            return this;
        }

        @Nonnull
        public Builder executeGoal(String executeGoal) {
            this.executeGoal = executeGoal;
            return this;
        }

        @Nonnull
        public Builder executeLifecycle(String executeLifecycle) {
            this.executeLifecycle = executeLifecycle;
            return this;
        }

        @Nonnull
        public Builder dependencyResolution(String dependencyResolution) {
            this.dependencyResolution = dependencyResolution;
            return this;
        }

        @Nonnull
        public Builder dependencyCollection(String dependencyCollection) {
            this.dependencyCollection = dependencyCollection;
            return this;
        }

        @Nonnull
        public Builder directInvocationOnly(boolean directInvocationOnly) {
            this.directInvocationOnly = directInvocationOnly;
            return this;
        }

        @Nonnull
        public Builder projectRequired(boolean projectRequired) {
            this.projectRequired = projectRequired;
            return this;
        }

        @Nonnull
        public Builder onlineRequired(boolean onlineRequired) {
            this.onlineRequired = onlineRequired;
            return this;
        }

        @Nonnull
        public Builder aggregator(boolean aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        @Nonnull
        public Builder inheritedByDefault(boolean inheritedByDefault) {
            this.inheritedByDefault = inheritedByDefault;
            return this;
        }

        @Nonnull
        public Builder since(String since) {
            this.since = since;
            return this;
        }

        @Nonnull
        public Builder deprecated(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        @Nonnull
        public Builder configurator(String configurator) {
            this.configurator = configurator;
            return this;
        }

        @Nonnull
        public Builder parameters(Collection<Parameter> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder fullGoalName(String fullGoalName) {
            this.fullGoalName = fullGoalName;
            return this;
        }


        @Nonnull
        public MojoDescriptor build() {
            if (base != null
                    && (goal == null || goal == base.goal)
                    && (description == null || description == base.description)
                    && (implementation == null || implementation == base.implementation)
                    && (language == null || language == base.language)
                    && (phase == null || phase == base.phase)
                    && (executePhase == null || executePhase == base.executePhase)
                    && (executeGoal == null || executeGoal == base.executeGoal)
                    && (executeLifecycle == null || executeLifecycle == base.executeLifecycle)
                    && (dependencyResolution == null || dependencyResolution == base.dependencyResolution)
                    && (dependencyCollection == null || dependencyCollection == base.dependencyCollection)
                    && (directInvocationOnly == null || directInvocationOnly == base.directInvocationOnly)
                    && (projectRequired == null || projectRequired == base.projectRequired)
                    && (onlineRequired == null || onlineRequired == base.onlineRequired)
                    && (aggregator == null || aggregator == base.aggregator)
                    && (inheritedByDefault == null || inheritedByDefault == base.inheritedByDefault)
                    && (since == null || since == base.since)
                    && (deprecated == null || deprecated == base.deprecated)
                    && (configurator == null || configurator == base.configurator)
                    && (parameters == null || parameters == base.parameters)
                    && (id == null || id == base.id)
                    && (fullGoalName == null || fullGoalName == base.fullGoalName)
            ) {
                return base;
            }
            return new MojoDescriptor(
                goal != null ? goal : (base != null ? base.goal : null),
                description != null ? description : (base != null ? base.description : null),
                implementation != null ? implementation : (base != null ? base.implementation : null),
                language != null ? language : (base != null ? base.language : null),
                phase != null ? phase : (base != null ? base.phase : null),
                executePhase != null ? executePhase : (base != null ? base.executePhase : null),
                executeGoal != null ? executeGoal : (base != null ? base.executeGoal : null),
                executeLifecycle != null ? executeLifecycle : (base != null ? base.executeLifecycle : null),
                dependencyResolution != null ? dependencyResolution : (base != null ? base.dependencyResolution : null),
                dependencyCollection != null ? dependencyCollection : (base != null ? base.dependencyCollection : null),
                directInvocationOnly != null ? directInvocationOnly : (base != null ? base.directInvocationOnly : false),
                projectRequired != null ? projectRequired : (base != null ? base.projectRequired : true),
                onlineRequired != null ? onlineRequired : (base != null ? base.onlineRequired : false),
                aggregator != null ? aggregator : (base != null ? base.aggregator : false),
                inheritedByDefault != null ? inheritedByDefault : (base != null ? base.inheritedByDefault : true),
                since != null ? since : (base != null ? base.since : null),
                deprecated != null ? deprecated : (base != null ? base.deprecated : null),
                configurator != null ? configurator : (base != null ? base.configurator : null),
                parameters != null ? parameters : (base != null ? base.parameters : null),
                id != null ? id : (base != null ? base.id : null),
                fullGoalName != null ? fullGoalName : (base != null ? base.fullGoalName : null)
            );
        }
    }

}
