// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.plugin.descriptor.lifecycle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Root element of the <code>lifecycle.xml</code> file.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class LifecycleConfiguration
    implements Serializable
{
    final String namespaceUri;
    final String modelEncoding;
    /**
     */
    final List<Lifecycle> lifecycles;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    LifecycleConfiguration(
        String namespaceUri,
        String modelEncoding,
        Collection<Lifecycle> lifecycles
    ) {
        this.namespaceUri = namespaceUri;
        this.modelEncoding = modelEncoding;
        this.lifecycles = ImmutableCollections.copy(lifecycles);
    }

    public String getNamespaceUri() {
        return namespaceUri;
    }

    public String getModelEncoding() {
        return modelEncoding;
    }

    /**
     *
     * @return a {@code List<Lifecycle>}
     */
    @Nonnull
    public List<Lifecycle> getLifecycles() {
        return this.lifecycles;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code LifecycleConfiguration} instance using the specified lifecycles.
     *
     * @param lifecycles the new {@code Collection<Lifecycle>} to use
     * @return a {@code LifecycleConfiguration} with the specified lifecycles
     */
    @Nonnull
    public LifecycleConfiguration withLifecycles(Collection<Lifecycle> lifecycles) {
        return newBuilder(this, true).lifecycles(lifecycles).build();
    }

    /**
     * Creates a new {@code LifecycleConfiguration} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code LifecycleConfiguration}
     */
    @Nonnull
    public static LifecycleConfiguration newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code LifecycleConfiguration} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code LifecycleConfiguration}
     */
    @Nonnull
    public static LifecycleConfiguration newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code LifecycleConfiguration} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code LifecycleConfiguration} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code LifecycleConfiguration} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code LifecycleConfiguration} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(LifecycleConfiguration from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code LifecycleConfiguration} builder instance using the specified object as a basis.
     *
     * @param from the {@code LifecycleConfiguration} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(LifecycleConfiguration from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create LifecycleConfiguration instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        LifecycleConfiguration base;
        String namespaceUri;
        String modelEncoding;
        Collection<Lifecycle> lifecycles;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(LifecycleConfiguration base, boolean forceCopy) {
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.lifecycles = base.lifecycles;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder lifecycles(Collection<Lifecycle> lifecycles) {
            this.lifecycles = lifecycles;
            return this;
        }


        @Nonnull
        public LifecycleConfiguration build() {
            if (base != null
                    && (lifecycles == null || lifecycles == base.lifecycles)
            ) {
                return base;
            }
            return new LifecycleConfiguration(
                namespaceUri != null ? namespaceUri : (base != null ? base.namespaceUri : ""),
                modelEncoding != null ? modelEncoding : (base != null ? base.modelEncoding : "UTF-8"),
                lifecycles != null ? lifecycles : (base != null ? base.lifecycles : null)
            );
        }
    }

}
