// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Root element of the <code>plugin.xml</code> file.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PluginDescriptor
    implements Serializable
{
    final String namespaceUri;
    final String modelEncoding;
    /**
     * Name of the plugin.
     */
    final String name;
    /**
     * Description of the plugin.
     */
    final String description;
    /**
     * The group id of the plugin.
     */
    final String groupId;
    /**
     * The artifact id of the plugin.
     */
    final String artifactId;
    /**
     * The version of the plugin.
     */
    final String version;
    /**
     * 
     */
    final String goalPrefix;
    /**
     * 
     */
    final boolean isolatedRealm;
    /**
     * 
     */
    final boolean inheritedByDefault;
    /**
     * A version range which specifies the supported Java versions. A version range can either use the usual mathematical syntax "[2.0.10,2.1.0),[3.0,)" or use a single version "2.2.1". The latter is a short form for "[2.2.1,)", i.e. denotes the minimum version required.
     */
    final String requiredJavaVersion;
    /**
     * A version range which specifies the supported Maven versions. A version range can either use the usual mathematical syntax "[2.0.10,2.1.0),[3.0,)" or use a single version "2.2.1". The latter is a short form for "[2.2.1,)", i.e. denotes the minimum version required. This value takes precedence over the POMs Maven prerequisite.
     */
    final String requiredMavenVersion;
    /**
     * Description of each Mojo provided by the plugin.
     */
    final List<MojoDescriptor> mojos;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    PluginDescriptor(
        String namespaceUri,
        String modelEncoding,
        String name,
        String description,
        String groupId,
        String artifactId,
        String version,
        String goalPrefix,
        boolean isolatedRealm,
        boolean inheritedByDefault,
        String requiredJavaVersion,
        String requiredMavenVersion,
        Collection<MojoDescriptor> mojos
    ) {
        this.namespaceUri = namespaceUri;
        this.modelEncoding = modelEncoding;
        this.name = name;
        this.description = description;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.goalPrefix = goalPrefix;
        this.isolatedRealm = isolatedRealm;
        this.inheritedByDefault = inheritedByDefault;
        this.requiredJavaVersion = requiredJavaVersion;
        this.requiredMavenVersion = requiredMavenVersion;
        this.mojos = ImmutableCollections.copy(mojos);
    }

    public String getNamespaceUri() {
        return namespaceUri;
    }

    public String getModelEncoding() {
        return modelEncoding;
    }

    /**
     * Name of the plugin.
     *
     * @return a {@code String}
     */
    public String getName() {
        return this.name;
    }

    /**
     * Description of the plugin.
     *
     * @return a {@code String}
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * The group id of the plugin.
     *
     * @return a {@code String}
     */
    public String getGroupId() {
        return this.groupId;
    }

    /**
     * The artifact id of the plugin.
     *
     * @return a {@code String}
     */
    public String getArtifactId() {
        return this.artifactId;
    }

    /**
     * The version of the plugin.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * 
     *
     * @return a {@code String}
     */
    public String getGoalPrefix() {
        return this.goalPrefix;
    }

    /**
     * 
     *
     * @return a {@code boolean}
     */
    public boolean isIsolatedRealm() {
        return this.isolatedRealm;
    }

    /**
     * 
     *
     * @return a {@code boolean}
     */
    public boolean isInheritedByDefault() {
        return this.inheritedByDefault;
    }

    /**
     * A version range which specifies the supported Java versions. A version range can either use the usual mathematical syntax "[2.0.10,2.1.0),[3.0,)" or use a single version "2.2.1". The latter is a short form for "[2.2.1,)", i.e. denotes the minimum version required.
     *
     * @return a {@code String}
     */
    public String getRequiredJavaVersion() {
        return this.requiredJavaVersion;
    }

    /**
     * A version range which specifies the supported Maven versions. A version range can either use the usual mathematical syntax "[2.0.10,2.1.0),[3.0,)" or use a single version "2.2.1". The latter is a short form for "[2.2.1,)", i.e. denotes the minimum version required. This value takes precedence over the POMs Maven prerequisite.
     *
     * @return a {@code String}
     */
    public String getRequiredMavenVersion() {
        return this.requiredMavenVersion;
    }

    /**
     * Description of each Mojo provided by the plugin.
     *
     * @return a {@code List<MojoDescriptor>}
     */
    @Nonnull
    public List<MojoDescriptor> getMojos() {
        return this.mojos;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code PluginDescriptor} with the specified name
     */
    @Nonnull
    public PluginDescriptor withName(String name) {
        return newBuilder(this, true).name(name).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified description.
     *
     * @param description the new {@code String} to use
     * @return a {@code PluginDescriptor} with the specified description
     */
    @Nonnull
    public PluginDescriptor withDescription(String description) {
        return newBuilder(this, true).description(description).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code PluginDescriptor} with the specified groupId
     */
    @Nonnull
    public PluginDescriptor withGroupId(String groupId) {
        return newBuilder(this, true).groupId(groupId).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code PluginDescriptor} with the specified artifactId
     */
    @Nonnull
    public PluginDescriptor withArtifactId(String artifactId) {
        return newBuilder(this, true).artifactId(artifactId).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code PluginDescriptor} with the specified version
     */
    @Nonnull
    public PluginDescriptor withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified goalPrefix.
     *
     * @param goalPrefix the new {@code String} to use
     * @return a {@code PluginDescriptor} with the specified goalPrefix
     */
    @Nonnull
    public PluginDescriptor withGoalPrefix(String goalPrefix) {
        return newBuilder(this, true).goalPrefix(goalPrefix).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified isolatedRealm.
     *
     * @param isolatedRealm the new {@code boolean} to use
     * @return a {@code PluginDescriptor} with the specified isolatedRealm
     */
    @Nonnull
    public PluginDescriptor withIsolatedRealm(boolean isolatedRealm) {
        return newBuilder(this, true).isolatedRealm(isolatedRealm).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified inheritedByDefault.
     *
     * @param inheritedByDefault the new {@code boolean} to use
     * @return a {@code PluginDescriptor} with the specified inheritedByDefault
     */
    @Nonnull
    public PluginDescriptor withInheritedByDefault(boolean inheritedByDefault) {
        return newBuilder(this, true).inheritedByDefault(inheritedByDefault).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified requiredJavaVersion.
     *
     * @param requiredJavaVersion the new {@code String} to use
     * @return a {@code PluginDescriptor} with the specified requiredJavaVersion
     */
    @Nonnull
    public PluginDescriptor withRequiredJavaVersion(String requiredJavaVersion) {
        return newBuilder(this, true).requiredJavaVersion(requiredJavaVersion).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified requiredMavenVersion.
     *
     * @param requiredMavenVersion the new {@code String} to use
     * @return a {@code PluginDescriptor} with the specified requiredMavenVersion
     */
    @Nonnull
    public PluginDescriptor withRequiredMavenVersion(String requiredMavenVersion) {
        return newBuilder(this, true).requiredMavenVersion(requiredMavenVersion).build();
    }
    /**
     * Creates a new {@code PluginDescriptor} instance using the specified mojos.
     *
     * @param mojos the new {@code Collection<MojoDescriptor>} to use
     * @return a {@code PluginDescriptor} with the specified mojos
     */
    @Nonnull
    public PluginDescriptor withMojos(Collection<MojoDescriptor> mojos) {
        return newBuilder(this, true).mojos(mojos).build();
    }

    /**
     * Creates a new {@code PluginDescriptor} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PluginDescriptor}
     */
    @Nonnull
    public static PluginDescriptor newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code PluginDescriptor} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PluginDescriptor}
     */
    @Nonnull
    public static PluginDescriptor newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code PluginDescriptor} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code PluginDescriptor} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code PluginDescriptor} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code PluginDescriptor} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginDescriptor from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code PluginDescriptor} builder instance using the specified object as a basis.
     *
     * @param from the {@code PluginDescriptor} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginDescriptor from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create PluginDescriptor instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        PluginDescriptor base;
        String namespaceUri;
        String modelEncoding;
        String name;
        String description;
        String groupId;
        String artifactId;
        String version;
        String goalPrefix;
        Boolean isolatedRealm;
        Boolean inheritedByDefault;
        String requiredJavaVersion;
        String requiredMavenVersion;
        Collection<MojoDescriptor> mojos;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.isolatedRealm = false;
                this.inheritedByDefault = true;
            }
        }

        Builder(PluginDescriptor base, boolean forceCopy) {
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.name = base.name;
                this.description = base.description;
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.goalPrefix = base.goalPrefix;
                this.isolatedRealm = base.isolatedRealm;
                this.inheritedByDefault = base.inheritedByDefault;
                this.requiredJavaVersion = base.requiredJavaVersion;
                this.requiredMavenVersion = base.requiredMavenVersion;
                this.mojos = base.mojos;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder goalPrefix(String goalPrefix) {
            this.goalPrefix = goalPrefix;
            return this;
        }

        @Nonnull
        public Builder isolatedRealm(boolean isolatedRealm) {
            this.isolatedRealm = isolatedRealm;
            return this;
        }

        @Nonnull
        public Builder inheritedByDefault(boolean inheritedByDefault) {
            this.inheritedByDefault = inheritedByDefault;
            return this;
        }

        @Nonnull
        public Builder requiredJavaVersion(String requiredJavaVersion) {
            this.requiredJavaVersion = requiredJavaVersion;
            return this;
        }

        @Nonnull
        public Builder requiredMavenVersion(String requiredMavenVersion) {
            this.requiredMavenVersion = requiredMavenVersion;
            return this;
        }

        @Nonnull
        public Builder mojos(Collection<MojoDescriptor> mojos) {
            this.mojos = mojos;
            return this;
        }


        @Nonnull
        public PluginDescriptor build() {
            if (base != null
                    && (name == null || name == base.name)
                    && (description == null || description == base.description)
                    && (groupId == null || groupId == base.groupId)
                    && (artifactId == null || artifactId == base.artifactId)
                    && (version == null || version == base.version)
                    && (goalPrefix == null || goalPrefix == base.goalPrefix)
                    && (isolatedRealm == null || isolatedRealm == base.isolatedRealm)
                    && (inheritedByDefault == null || inheritedByDefault == base.inheritedByDefault)
                    && (requiredJavaVersion == null || requiredJavaVersion == base.requiredJavaVersion)
                    && (requiredMavenVersion == null || requiredMavenVersion == base.requiredMavenVersion)
                    && (mojos == null || mojos == base.mojos)
            ) {
                return base;
            }
            return new PluginDescriptor(
                namespaceUri != null ? namespaceUri : (base != null ? base.namespaceUri : ""),
                modelEncoding != null ? modelEncoding : (base != null ? base.modelEncoding : "UTF-8"),
                name != null ? name : (base != null ? base.name : null),
                description != null ? description : (base != null ? base.description : null),
                groupId != null ? groupId : (base != null ? base.groupId : null),
                artifactId != null ? artifactId : (base != null ? base.artifactId : null),
                version != null ? version : (base != null ? base.version : null),
                goalPrefix != null ? goalPrefix : (base != null ? base.goalPrefix : null),
                isolatedRealm != null ? isolatedRealm : (base != null ? base.isolatedRealm : false),
                inheritedByDefault != null ? inheritedByDefault : (base != null ? base.inheritedByDefault : true),
                requiredJavaVersion != null ? requiredJavaVersion : (base != null ? base.requiredJavaVersion : null),
                requiredMavenVersion != null ? requiredMavenVersion : (base != null ? base.requiredMavenVersion : null),
                mojos != null ? mojos : (base != null ? base.mojos : null)
            );
        }
    }


    public String getPluginLookupKey() {
        return groupId + ":" + artifactId;
    }

    public String getId() {
        return groupId + ":" + artifactId + ":" + version;
    }

          
}
