// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Definition of include or exclude patterns.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PatternSet
    implements Serializable, InputLocationTracker
{
    /**
     * A list of patterns to include, e.g. {@code **&#47;*.xml}.
     */
    final List<String> includes;
    /**
     * A list of patterns to exclude, e.g. {@code **&#47;*.xml}
     */
    final List<String> excludes;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected PatternSet(Builder builder) {
        this.includes = ImmutableCollections.copy(builder.includes != null ? builder.includes : (builder.base != null ? builder.base.includes : null));
        this.excludes = ImmutableCollections.copy(builder.excludes != null ? builder.excludes : (builder.base != null ? builder.base.excludes : null));
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * A list of patterns to include, e.g. {@code **&#47;*.xml}.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getIncludes() {
        return this.includes;
    }

    /**
     * A list of patterns to exclude, e.g. {@code **&#47;*.xml}
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getExcludes() {
        return this.excludes;
    }

    /**
     * Gets the location of the specified field in the input source.
     *
     * @param key the key of the field, must not be {@code null}
     * @return the location of the field in the input source or {@code null} if unknown
     * @throws NullPointerException if {@code key} is {@code null}
     */
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code PatternSet} instance using the specified includes.
     *
     * @param includes the new {@code Collection<String>} to use
     * @return a {@code PatternSet} with the specified includes
     */
    @Nonnull
    public PatternSet withIncludes(Collection<String> includes) {
        return newBuilder(this, true).includes(includes).build();
    }
    /**
     * Creates a new {@code PatternSet} instance using the specified excludes.
     *
     * @param excludes the new {@code Collection<String>} to use
     * @return a {@code PatternSet} with the specified excludes
     */
    @Nonnull
    public PatternSet withExcludes(Collection<String> excludes) {
        return newBuilder(this, true).excludes(excludes).build();
    }

    /**
     * Creates a new {@code PatternSet} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PatternSet}
     */
    @Nonnull
    public static PatternSet newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code PatternSet} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PatternSet}
     */
    @Nonnull
    public static PatternSet newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code PatternSet} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code PatternSet} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code PatternSet} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code PatternSet} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PatternSet from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code PatternSet} builder instance using the specified object as a basis.
     *
     * @param from the {@code PatternSet} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PatternSet from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create PatternSet instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        PatternSet base;
        Collection<String> includes;
        Collection<String> excludes;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(PatternSet base, boolean forceCopy) {
            if (forceCopy) {
                this.includes = base.includes;
                this.excludes = base.excludes;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public PatternSet build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (includes == null || includes == base.includes)
                    && (excludes == null || excludes == base.excludes)
            ) {
                return base;
            }
            return new PatternSet(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "PatternSet [" +
            "includes: {" + getIncludes().stream().collect(java.util.stream.Collectors.joining(", ")) + "}, " +
            "excludes: {" + getExcludes().stream().collect(java.util.stream.Collectors.joining(", ")) + "}]";
    }
            
          
}
