// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <parent>} element contains information required to locate the parent project from which
 * this project will inherit from.
 * <p><strong>Note:</strong> The children of this element are not interpolated and must be given as literal values.</p>
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Parent
    implements Serializable, InputLocationTracker
{
    /**
     * The group id of the parent project to inherit from.
     */
    final String groupId;
    /**
     * The artifact id of the parent project to inherit from.
     */
    final String artifactId;
    /**
     * The version of the parent project to inherit.
     */
    final String version;
    /**
     * The relative path of the parent subproject POM file or directory within the checkout.
     * If not specified, it defaults to {@code ..}, i.e. the parent directory.
     * Maven looks for the parent POM first in this location on
     * the filesystem if explicitly provided, then in the reactor if groupId and artifactId are provided,
     * then in the default parent directory, then the local repository, and lastly in the remote repo.
     * However, if the both relative path and the group ID / artifact ID are provided,
     * they must match the file in the location given.
     * Specify either the {@code relativePath} or the {@code groupId}/{@code artifactId}, not both.
     */
    final String relativePath;
    /** Locations */
    final Map<Object, InputLocation> locations;
    /** Location tracking */
    final InputLocation importedFrom;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Parent(Builder builder) {
        this.groupId = builder.groupId != null ? builder.groupId : (builder.base != null ? builder.base.groupId : null);
        this.artifactId = builder.artifactId != null ? builder.artifactId : (builder.base != null ? builder.base.artifactId : null);
        this.version = builder.version != null ? builder.version : (builder.base != null ? builder.base.version : null);
        this.relativePath = builder.relativePath != null ? builder.relativePath : (builder.base != null ? builder.base.relativePath : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    /**
     * The group id of the parent project to inherit from.
     *
     * @return a {@code String}
     */
    public String getGroupId() {
        return this.groupId;
    }

    /**
     * The artifact id of the parent project to inherit from.
     *
     * @return a {@code String}
     */
    public String getArtifactId() {
        return this.artifactId;
    }

    /**
     * The version of the parent project to inherit.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * The relative path of the parent subproject POM file or directory within the checkout.
     * If not specified, it defaults to {@code ..}, i.e. the parent directory.
     * Maven looks for the parent POM first in this location on
     * the filesystem if explicitly provided, then in the reactor if groupId and artifactId are provided,
     * then in the default parent directory, then the local repository, and lastly in the remote repo.
     * However, if the both relative path and the group ID / artifact ID are provided,
     * they must match the file in the location given.
     * Specify either the {@code relativePath} or the {@code groupId}/{@code artifactId}, not both.
     *
     * @return a {@code String}
     */
    public String getRelativePath() {
        return this.relativePath;
    }

    /**
     * Gets the location of the specified field in the input source.
     *
     * @param key the key of the field, must not be {@code null}
     * @return the location of the field in the input source or {@code null} if unknown
     * @throws NullPointerException if {@code key} is {@code null}
     */
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return locations.get(key);
    }

    /**
     * Gets the keys of the locations of the input source.
     */
    public Set<Object> getLocationKeys() {
        return locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return locations.keySet().stream();
    }

    /**
     * Gets the input location that caused this model to be read.
     */
    public InputLocation getImportedFrom() {
        return importedFrom;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Parent} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Parent} with the specified groupId
     */
    @Nonnull
    public Parent withGroupId(String groupId) {
        return newBuilder(this, true).groupId(groupId).build();
    }
    /**
     * Creates a new {@code Parent} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Parent} with the specified artifactId
     */
    @Nonnull
    public Parent withArtifactId(String artifactId) {
        return newBuilder(this, true).artifactId(artifactId).build();
    }
    /**
     * Creates a new {@code Parent} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Parent} with the specified version
     */
    @Nonnull
    public Parent withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }
    /**
     * Creates a new {@code Parent} instance using the specified relativePath.
     *
     * @param relativePath the new {@code String} to use
     * @return a {@code Parent} with the specified relativePath
     */
    @Nonnull
    public Parent withRelativePath(String relativePath) {
        return newBuilder(this, true).relativePath(relativePath).build();
    }

    /**
     * Creates a new {@code Parent} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Parent}
     */
    @Nonnull
    public static Parent newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Parent} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Parent}
     */
    @Nonnull
    public static Parent newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Parent} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Parent} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Parent} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Parent} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Parent from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Parent} builder instance using the specified object as a basis.
     *
     * @param from the {@code Parent} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Parent from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Parent instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Parent base;
        String groupId;
        String artifactId;
        String version;
        String relativePath;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        protected Builder(Parent base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.relativePath = base.relativePath;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder relativePath(String relativePath) {
            this.relativePath = relativePath;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Parent build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (groupId == null || groupId == base.groupId)
                    && (artifactId == null || artifactId == base.artifactId)
                    && (version == null || version == base.version)
                    && (relativePath == null || relativePath == base.relativePath)
            ) {
                return base;
            }
            return new Parent(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map<Object, InputLocation> newlocs = locations != null ? locations : Map.of();
            Map<Object, InputLocation> oldlocs = base != null ? base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream())
                    // Keep value from newlocs in case of duplicates
                    .collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }


            
    /**
     * @return the id as {@code groupId:artifactId:version}
     */
    public String getId() {
        return getGroupId() + ":" + getArtifactId() + ":pom:" + getVersion();
    }

    @Override
    public String toString() {
        return getId();
    }
            
          
}
